import request from '@/utils/http.ts'
import config from '@/utils/config.ts'


// 登录
export function loginApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/login`,
    method: 'post',
    data
  })
}



// 会员列表
export function getMembersListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/member/list`,
    method: 'get',
    params
  })
}

// 会员详情
export function getMembersDetailApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/member/detail/${params}`,
    method: 'get'
  })
}

// 会员详情
export function updateMembersDetailApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/member/update/${data.id}`,
    method: 'post',
    data: data
  })
}

// 修改会员状态
export function changeMemberStatusApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/member/change/state/${data}`,
    method: 'post'
  })
}

// 删除会员
export function deleteMemberApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/member/destroy/${data}`,
    method: 'post'
  })
}


// 上传文件
export function uploadFileApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/staking/upload`,
    method: 'post',
    headers: {
      "Content-Type": "multipart/form-data",
    },
    data
  })
}






// 持币列表
export function getCoinListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/member/coin/list/${params}`,
    method: 'get'
  })
}

// 修改持币信息
export function editCoinApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/member/coin/update/${data.id}`,
    method: 'post',
    data
  })
}






// 质押列表
export function getStakingListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/member/staking/${params}`,
    method: 'get'
  })
}

// 开始质押
export function startStakingApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/member/staking/start/${data.id}`,
    method: 'post',
    data
  })
}

// 结束质押
export function endStakingApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/member/staking/end/${data.id}`,
    method: 'post',
    data
  })
}




// 邀请码列表
export function getCodeListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/signup_code/list`,
    method: 'get',
    params
  })
}

// 添加邀请码
export function addCodeApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/signup_code/store`,
    method: 'post',
    data
  })
}

// 删除邀请码
export function deleteCodeApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/signup_code/destroy/${data}`,
    method: 'post'
  })
}



// 充值/提款列表
export function getMoneyInOutListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/money_in_out/list`,
    method: 'get',
    params
  })
}

// 变更充值/提款状态
export function editMoneyInOutStatusApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/money_in_out/change/state/${data.id}`,
    method: 'post',
    data
  })
}

// 删除充值/提款
export function deleteMoneyInOutApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/money_in_out/destroy/${data}`,
    method: 'post'
  })
}








// 质押产品列表
export function getStakingProductListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/staking/product/list`,
    method: 'get',
    params
  })
}

// 质押产品详情
export function getStakingProductDetailApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/staking/product/detail/${params}`,
    method: 'get'
  })
}



// 修改质押产品
export function editStakingProductApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/staking/product/update/${data.id}`,
    method: 'post',
    data
  })
}


// 删除质押产品
export function deleteStakingProductApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/staking/product/destroy/${data}`,
    method: 'post'
  })
}

// 质押进度列表
export function getStakingUserListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/staking/user/list`,
    method: 'get',
    params
  })
}

// 删除质押进度
export function deleteStakingUserApi(data: any) {
  return request({
    url: `${config.baseURL}/admin/staking/user/destroy/${data.id}`,
    method: 'post',
    data
  })
}

// 质押历史列表
export function getStakingHistoryListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/staking/user/list/history`,
    method: 'get',
    params
  })
}

// 质押奖励支付列表
export function getStakingRewardListApi(params: any) {
  return request({
    url: `${config.baseURL}/admin/staking/user/reward`,
    method: 'get',
    params
  })
}


// // 质押奖励支付列表
// export function getStakingRewardListApi(params: any) {
//   return request({
//     url: `${config.baseURL}/pledge/upload`,
//     method: 'get',
//     params
//   })
// }
