// 前往下一个页面
export function goPage(e: string) {
  uni.navigateTo({
    url: e
  })
}

// 返回下一个页面
export function goBack(delta: number = 1) {
  uni.navigateBack({
    delta
  })
}

// 删除当前页并前往下一个页面
export function reLaunch(e: string) {
  uni.reLaunch({
    url: e
  })
}

// 跳转到tabbar
export function switchTab(e: string) {
  uni.switchTab({
    url: e
  })
}

// 时间戳转换
export const timestempToDate = (timestamp: number, n: string = '-') => {
  const date = new Date(timestamp + 3600000 * 9)
  const year = date.getUTCFullYear()
  const month = date.getUTCMonth() - 1 < 10 ? `0${date.getUTCMonth() - 1}` : date.getUTCMonth() - 1
  const day = date.getUTCDate() < 10 ? `0${date.getUTCDate()}` : date.getUTCDate()
  const hour = date.getUTCHours() < 10 ? `0${date.getUTCHours()}` : date.getUTCHours()
  const minute = date.getUTCMinutes() < 10 ? `0${date.getUTCMinutes()}` : date.getUTCMinutes()
  return `${year}${n}${month}${n}${day} ${hour}:${minute}`
}

export function timestampToDate2(timestamp: number) {
  const date = new Date(timestamp + 3600000 * 9)
  const year = date.getUTCFullYear() // 获取年份
  let month = date.getUTCMonth() + 1 // 获取月份，需要+1因为月份从0开始
  let day = date.getUTCDate() // 获取日
  let hours = date.getUTCHours() // 获取小时
  let minutes = date.getUTCMinutes() // 获取分钟
  let seconds = date.getUTCSeconds() // 获取秒钟

  // 格式化月份、日期、小时、分钟和秒
  month = month < 10 ? '0' + month : month
  day = day < 10 ? '0' + day : day
  hours = hours < 10 ? '0' + hours : hours
  minutes = minutes < 10 ? '0' + minutes : minutes
  seconds = seconds < 10 ? '0' + seconds : seconds

  // 组合成日期时间字符串
  return year + '-' + month + '-' + day + ' ' + hours + ':' + minutes + ':' + seconds
}

// 获取股票颜色
export const getColor = (item: any, type: boolean = false) => {
  if (type && item.zhangdiebaifenbi > 0) {
    return 'up rotate'
  }
  return item.zhangdiebaifenbi > 0 ? 'up' : item.zhangdiebaifenbi === 0 ? 'ping' : 'down'
}

// 验证输入框内容是否为空
interface checkType {
  key: string
  message: string
}
interface dataType {
  [key: string]: string | null
}
export function checkInput(checkArr: Array<checkType>, data: dataType) {
  for (const i in checkArr) {
    if (!data[checkArr[i].key]) {
      uni.showToast({
        title: checkArr[i].message,
        icon: 'none'
      })
      return false
    }
  }
  return true
}

// 价格转换（加逗号）
export const changeMoney = (money: any) => {
  money = Number(money).toFixed(1)
  money += ''
  const x = money.split('.')
  let x1 = x[0]
  const x2 = x.length > 1 ? '.' + x[1] : ''
  const reg = /(\d+)(\d{3})/
  while (reg.test(x1)) {
    x1 = x1.replace(reg, '$1' + ',' + '$2')
  }
  return x1 + x2
}
