package com.live.job.controller;

import com.live.common.domain.ResponseData;
import com.live.job.entity.RequestUrl;
import com.live.job.service.CrawlStrategyFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/crawlLeYu")
@Api(tags = "爬取 乐鱼体育 接口文档")
public class CrawlLeYuController {

    private final String platform = "LeYu";
    @Resource
    private CrawlStrategyFactory crawStrategyFactory;

    @PostMapping(value = "/crawLeYuMatchSchedule")
    @ApiOperation(value = "爬取乐鱼 赛程 列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> crawLeYuMatchSchedule(@RequestBody RequestUrl requestUrl, HttpServletRequest request) {
        crawStrategyFactory.getCrawMatchService(platform).crawlScheduleMatch(requestUrl.getUrl());
        return ResponseData.successResponse();
    }

}
