package com.live.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.live.common.domain.dto.back.SysRoleDTO;
import com.live.common.domain.entity.SysRole;
import com.live.common.domain.request.back.RoleVO;
import com.live.common.domain.request.back.RolesVO;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @Author: bob
 * @Date: 2020/6/15 10:16
 * @Version 1.0
 */
public interface SysRoleMapper extends BaseMapper<SysRole> {

    @Select("select * from t_sys_role as r,t_sys_menu  as m where r.id=#{id} and r.menu_id=m.id ")
    List<SysRoleDTO> getRoleMenu(Integer id);

    @Select("select role_name,menu_id from t_sys_user as u LEFT JOIN t_sys_role  as r on u.role_id=r.id where u.role_id=#{id}")
    List<RoleVO> getSysRoleMenu(Integer id);

    @Select("select * from t_sys_role where deleted=0 ORDER BY create_time desc")
    List<RolesVO> getRoleVOs();
}
