package com.live.common.service;

import com.live.common.domain.ResponseData;
import com.live.common.domain.entity.Room;
import com.live.common.domain.request.*;
import com.live.common.domain.request.back.EditRobotMsgRequest;
import com.live.common.domain.request.back.EditRoomRequest;
import com.live.common.domain.request.back.GetRoomListRequest;

import javax.servlet.http.HttpServletRequest;

public interface RoomService {

    ResponseData<?> getGiftList(HttpServletRequest request);

    ResponseData<?> sendGift(SendGiftRequest sendGiftRequest, HttpServletRequest request);

    ResponseData<?> getBannerList(HttpServletRequest request);

    ResponseData<?> getTopMatchList(HttpServletRequest request);

    ResponseData<?> getHotLiveList(CommonPage commonPage, HttpServletRequest request);

    ResponseData<?> getTopLiveList(TopLiveRequest topLiveRequest, HttpServletRequest request);

    ResponseData<?> getVideoRecommendList(VideoRecommendRequest commonPage, HttpServletRequest request);

    ResponseData<?> getChatMessage(HttpServletRequest request);

    //PC
    ResponseData<?> getHotAnchor(HttpServletRequest request);

    ResponseData<?> getPushStreamUrl(CommonStringId commonStringId, HttpServletRequest request);

    ResponseData<?> getLiveStreamingToPc(HttpServletRequest request);

    //back console
    ResponseData<?> getRoomList(GetRoomListRequest commonPage, HttpServletRequest request);

    ResponseData<?> editRoomById(EditRoomRequest editRoomRequest, HttpServletRequest request);

    ResponseData<?> getRobotMsgList(CommonPage commonPage, HttpServletRequest request);

    ResponseData<?> editRobotMsg(EditRobotMsgRequest editRobotMsgRequest, HttpServletRequest request);

    //Job
    Room getVacancyRoom();

    void createVacancyRoom(String roomName, Integer type, String liveUrl);

}
