package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.service.CosImageService;
import io.swagger.annotations.*;
import org.apache.commons.io.FileUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;

@CrossOrigin
@RestController
@RequestMapping("/file")
@Api(tags = "图片上传接口")
public class FileController {

    @Resource
    private CosImageService cosImageService;

    @PostMapping(value = "/fileUpload")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> fileNewUpload(@RequestParam(value = "file") MultipartFile mFile, HttpServletRequest request) throws IOException {
        if (!mFile.isEmpty()) {
            //multipartFile转为file
            File file = new File(this.getClass().getResource("/temporary/test.jpg").getPath());
            FileUtils.copyInputStreamToFile(mFile.getInputStream(), file);
            return ResponseData.successResponse(cosImageService.uploadImage(file, null));
        }
        return ResponseData.fail400Response("请选择上传文件");
    }
}