//package com.live.server.aspect;
//
//import com.alibaba.fastjson.JSONObject;
//import com.alibaba.fastjson.support.spring.PropertyPreFilters;
//import com.live.common.utils.IPUtil;
//import org.aspectj.lang.JoinPoint;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.Signature;
//import org.aspectj.lang.annotation.Around;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.annotation.Before;
//import org.aspectj.lang.annotation.Pointcut;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.stereotype.Component;
//import org.springframework.util.StringUtils;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//import org.springframework.web.multipart.MultipartFile;
//
//import javax.servlet.ServletRequest;
//import javax.servlet.ServletResponse;
//import javax.servlet.http.HttpServletRequest;
//import java.lang.reflect.Field;
//
//@Aspect
//@Component
//public class LogAspect {
//
//    private final static Logger logger = LoggerFactory.getLogger(LogAspect.class);
//
//    @Pointcut("execution(public * com.live.server.controller..*Controller.*(..))")
//    public void controllerPointcut() {}
//
//    @Before("controllerPointcut()")
//    public void doBefore(JoinPoint joinPoint) throws Throwable {
//        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
//        HttpServletRequest request = attributes.getRequest();
//        Signature signature = joinPoint.getSignature();
//        String name = signature.getName();
//
//        String nameCn = "";
//        if (name.contains("list") || name.contains("query")) {
//            nameCn = "查询";
//        } else if (name.contains("save")) {
//            nameCn = "保存";
//        } else if (name.contains("delete")) {
//            nameCn = "删除";
//        } else {
//            nameCn = "操作";
//        }
//        Class clazz = signature.getDeclaringType();
//        Field field;
//        String businessName = "";
//        try {
//            field = clazz.getField("BUSINESS_NAME");
//            if (!StringUtils.isEmpty(field)) {
//                businessName = (String) field.get(clazz);
//            }
//        } catch (NoSuchFieldException e) {
//            logger.error("未获取到业务名称");
//        } catch (SecurityException e) {
//            logger.error("获取业务名称失败", e);
//        }
//
//        logger.info("------------- 【{}】{}开始 -------------", businessName, nameCn);
//        logger.info("deviceId: {}", request.getHeader("device-id"));
//        logger.info("请求地址: {} {}", request.getRequestURL().toString(), request.getMethod());
//        logger.info("类名方法: {}.{}", signature.getDeclaringTypeName(), name);
//        logger.info("远程地址: {}", IPUtil.getClientIP(request));
//
//        Object[] args = joinPoint.getArgs();
//        Object[] arguments  = new Object[args.length];
//        for (int i = 0; i < args.length; i++) {
//            if (args[i] instanceof ServletRequest
//                    || args[i] instanceof ServletResponse
//                    || args[i] instanceof MultipartFile) {
//                continue;
//            }
//            arguments[i] = args[i];
//        }
//
//        String[] excludeProperties = {"shard"};
//        PropertyPreFilters filters = new PropertyPreFilters();
//        PropertyPreFilters.MySimplePropertyPreFilter excludefilter = filters.addFilter();
//        excludefilter.addExcludes(excludeProperties);
//        logger.info("请求参数: {}", JSONObject.toJSONString(arguments, excludefilter));
//    }
//
//    @Around("controllerPointcut()")
//    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
//        long startTime = System.currentTimeMillis();
//        Object result = proceedingJoinPoint.proceed();
//        String[] excludeProperties = {"password", "shard"};
//        PropertyPreFilters filters = new PropertyPreFilters();
//        PropertyPreFilters.MySimplePropertyPreFilter excludefilter = filters.addFilter();
//        excludefilter.addExcludes(excludeProperties);
//        String jsonResult = JSONObject.toJSONString(result, excludefilter);
//        String show = jsonResult.length() >1024?jsonResult.substring(0,1024):jsonResult;
//        logger.info("返回结果: {}", show);
//        logger.info("------------- 结束 耗时：{} ms -------------", System.currentTimeMillis() - startTime);
//        return result;
//    }
//}