package com.live.common.service;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.api.MatchBasketballOddsResponse;
import com.live.common.domain.dto.api.MatchFootballOddsResponse;
import com.live.common.domain.dto.api.MatchListResponse;
import com.live.common.domain.entity.Match;
import com.live.common.domain.request.*;
import com.live.common.domain.request.back.*;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface MatchService {

    ResponseData<?> getMatchList(GetMatchListRequest commonStringId, HttpServletRequest request);

    ResponseData<?> getMatchInfo(CommonStringId commonStringId, HttpServletRequest request);

    ResponseData<?> userReserveMatch(CommonStringId commonStringId, HttpServletRequest request);

    ResponseData<?> userCancelReserveMatch(CommonStringId commonStringId, HttpServletRequest request);

    ResponseData<?> userGetReserveMatch(HttpServletRequest request);

    ResponseData<?> userGetAnchorList(HttpServletRequest request);

    ResponseData<?> userFollowAnchor(CommonStringId commonIntId, HttpServletRequest request);

    ResponseData<?> userUnFollowAnchor(CommonStringId commonIntId, HttpServletRequest request);

    MatchListResponse conversionByList(List<Match> matches, boolean otherAnchors);

    ResponseData<?> matchInfoBasketball(CommonStringId commonIntId, HttpServletRequest request);

    ResponseData<?> matchInfoFootball(CommonStringId commonIntId, HttpServletRequest request);

    ResponseData<?> getMatchSummaryById(MatchSummaryRequest summaryRequest);

    ResponseData<?> getMatchLiveList(CommonStringId commonStringId);

    ResponseData<MatchFootballOddsResponse> matchFootballOdds(CommonStringId commonIntId, HttpServletRequest request);

    ResponseData<MatchBasketballOddsResponse> matchBasketballOdds(CommonStringId commonIntId, HttpServletRequest request);

    ResponseData<?> getMatchNewsById(GetMatchNewsByIdRequest getMatchNewsById, HttpServletRequest request);

    ResponseData<?> getHotRankInfoById(CommonIntId commonIntId, HttpServletRequest request);

    ResponseData<?> getHotRankList(GetMatchNewsByIdRequest matchNewsByIdRequest, HttpServletRequest request);

    ResponseData<?> getHotRankAssociate(RankAssociateRequest commonIntId, HttpServletRequest request);

    // back console
    ResponseData<?> backGetMatchList(CommonPage commonPage, HttpServletRequest request);

    ResponseData<?> getSportsList(HttpServletRequest request);

    ResponseData<?> addMatch(AddMatchRequest addMatchRequest, HttpServletRequest request);

    ResponseData<?> updateMatch(UpdateMatchRequest updateMatch, HttpServletRequest request);

    ResponseData<?> getMatchLiveConfigList(MatchLiveListRequest commonPage, HttpServletRequest request);

    ResponseData<?> getHotRankListBack(HotRankListRequest rankListRequest, HttpServletRequest request);

    ResponseData<?> editHotRankInfo(EditHotRankInfoRequest rankListRequest, HttpServletRequest request);

    ResponseData<?> matchLiveConfig(MatchLiveConfigRequest matchLiveConfigRequest, HttpServletRequest request);

}
