package com.live.console.config;

import com.live.common.service.RedisUtilsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class IntercaptorConfig implements WebMvcConfigurer {

    @Autowired
    private RedisUtilsService redisUtilsService;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new JWTInterceptor(redisUtilsService))
                //拦截的路径
                .addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**")

                .excludePathPatterns("/sys/login", "/sys/reg");

    }
}