package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.SysUserDTO;
import com.live.common.domain.request.CommonIntId;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.LoginBackRequest;
import com.live.common.domain.request.back.SysEditPwdRequest;
import com.live.common.service.ISysUserService;
import com.live.common.service.LoginService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/sys")
public class SysUserController {

    @Resource
    private LoginService loginService;
    @Resource
    private ISysUserService sysUserService;

    @PostMapping("/reg")
    @ApiOperation("用户注册")
    public ResponseData<?> register(@RequestBody SysUserDTO sysUserDTO){
        return sysUserService.register(sysUserDTO);
    }

    @PostMapping(value = "/login")
    @ApiOperation(value = "登录接口", notes = "登录接口")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> login(@RequestBody LoginBackRequest loginBackRequest, HttpServletRequest request) {
        return loginService.login(loginBackRequest, request);
    }

    //todo logout
    @PostMapping("/logout")
    @ApiOperation("用户登出")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> logout(HttpServletRequest request){
        return loginService.logout(request);
    }

    @PostMapping("/deleteSysUser")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> deleteSysUser(@RequestBody CommonIntId commonIntId, HttpServletRequest request){
        return sysUserService.deleteSysUser(commonIntId, request);
    }

    @PostMapping("/list")
    @ApiOperation("用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public  ResponseData<?> findUserList(@RequestBody CommonPage commonPageNum){
        return sysUserService.getSysUserList(commonPageNum);
    }

    @PostMapping("/editUserInfo")
    @ApiOperation("修改用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public  ResponseData<?> editUserInfo(@RequestBody SysEditPwdRequest sysEditPwdRequest, HttpServletRequest request){
        return sysUserService.editUserInfo(sysEditPwdRequest, request);
    }

    @PostMapping("/public/menus")
    @ApiOperation("左边栏菜单页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public  ResponseData<?> menuNames(HttpServletRequest request){
        return sysUserService.menuNames(request);
    }

}
