package com.live.common.domain.dto.api;

import io.swagger.models.auth.In;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeaguePointsRankFootballResponse {

    private String groupName;

    private List<RankFootballResponse> rankFootball;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class RankFootballResponse {
        private String teamName;
        private String teamIcon;
        private Integer wins;
        private Integer draws;
        private Integer losts;
        private Integer points;
    }

}
