package com.live.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.live.common.domain.dto.api.GetLeaderboardResponse;
import com.live.common.domain.entity.Gift;
import com.live.common.domain.entity.GiftRecord;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

public interface GiftRecordMapper extends BaseMapper<GiftRecord> {

    @Select("select * from (select SUM(gift_gold) as gift_gold, user_id from t_gift_record where host_user_id = #{userId} and deleted = 0 GROUP BY user_id) as lsb ORDER BY lsb.gift_gold desc limit 0,10 ")
    List<GetLeaderboardResponse> getLeaderboard(@Param("userId") String userId);

}
