package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.back.AddGiftRequest;
import com.live.common.domain.request.back.GiftRecordRequest;
import com.live.common.service.CosImageService;
import com.live.common.service.GiftService;
import io.swagger.annotations.*;
import org.apache.commons.io.FileUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;

@CrossOrigin
@RestController
@RequestMapping("/gift")
@Api(tags = "直播礼物接口")
public class GiftController {

    @Resource
    private GiftService giftService;

    @PostMapping(value = "/getGiftList")
    @ApiOperation(value = "礼物列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getGiftList(@RequestBody CommonPage commonPage, HttpServletRequest request) throws IOException {
        return giftService.getGiftList(commonPage);
    }

    @PostMapping(value = "/addGift")
    @ApiOperation(value = "新增礼物")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> addGift(@RequestBody AddGiftRequest addGiftRequest, HttpServletRequest request) throws IOException {
        return giftService.addGift(addGiftRequest);
    }

    @PostMapping(value = "/editGift")
    @ApiOperation(value = "修改礼物信息")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editGift(@RequestBody AddGiftRequest addGiftRequest, HttpServletRequest request) throws IOException {
        return giftService.editGift(addGiftRequest);
    }

    @PostMapping(value = "/getGiftRecord")
    @ApiOperation(value = "获取礼物赠送记录")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getGiftRecord(@RequestBody GiftRecordRequest commonPage, HttpServletRequest request) throws IOException {
        return giftService.getGiftRecord(commonPage, request);
    }
}