package com.live.common.service;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonStringId;
import com.live.common.domain.request.CreateRoomRequest;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;

public interface LiveService {

    ResponseData<?> getMatchListByType(CommonStringId commonStringId, HttpServletRequest request);

    ResponseData<?> getRoomInfoByUser(HttpServletRequest request);

    ResponseData<?> createRoom(CreateRoomRequest roomRequest, HttpServletRequest request);

    ResponseData<?> createRoom(CreateRoomRequest roomRequest, String userId, String liveUrl);

    ResponseData<?> editRoom(CreateRoomRequest roomRequest, HttpServletRequest request);

    ResponseData<?> createPushUrl(HttpServletRequest request);

    ResponseData<?> createAliPushUrl(HttpServletRequest request);

    ResponseData<?> createPlayUrl(HttpServletRequest request);

}
