package com.live.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

/**
 * 加密工具 系统安全相关的工具类.
 * 
 */
public class SecurityUtil {
	private static final String DEFAULT_ENCODING = "UTF-8";
	private static final char HEXDIGITS[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd',
			'e', 'f' };

	/**
	 * @Description : 16位md5加密
	 * @param s
	 * @return
	 */
	public String encode16(String s) throws Exception {
		String tmp = encryptMd5(s);
		if (tmp != null) {
			return tmp.substring(8, 24);
		} else {
			return tmp;
		}
	}

	/**
	 * 对内容进行MD5加密
	 * 
	 * @param content
	 *            内容
	 * @return 加密后的内容
	 */
	public static String encryptMd5(String content) throws Exception {
		return getMD5(content, DEFAULT_ENCODING);
	}

	/**
	 * md5加密
	 * 
	 * @param flag
	 *            true-大写；false-小写
	 * @param args
	 *            按顺序拼接加密串
	 * @return
	 */
	public static String crtyMd5(boolean flag, String... args) {
		return crtyMd5(DEFAULT_ENCODING, flag, args);
	}
	/**
	 * md5加密,返回小写
	 * @param args
	 *            按顺序拼接加密串
	 * @return
	 */
	public static String crtyMd5(String... args) {
		return crtyMd5(DEFAULT_ENCODING, false, args);
	}
	/**
	 * md5加密
	 * 
	 * @param encoding
	 *            字符编码
	 * @param flag
	 *            true-大写；false-小写
	 * @param args
	 *            按顺序拼接加密串
	 * @return
	 */
	public static String crtyMd5(String encoding, boolean flag, String... args) {
		if (StringUtils.isBlank(encoding))
			encoding = DEFAULT_ENCODING;
		StringBuffer sb = new StringBuffer();
		if (args != null) {
			for (String tmp : args) {
				if (tmp == null)
					tmp = "";
				sb.append(tmp);
			}
		}
		String sign = "";
		try {
			sign = getMD5(sb.toString(), encoding);
		} catch (Exception e) {
		}
		
		if (flag) {
			sign = sign.toUpperCase();
		} else {
			sign = sign.toLowerCase();
		}
		return sign;
	}

	/**
	 * md5加密
	 * 
	 * @param s
	 *            加密串
	 * @param encoding
	 *            字符编码
	 * @return
	 * @throws Exception
	 */
	public static String getMD5(String s, String encoding) throws Exception {
		if (StringUtils.isBlank(encoding))
			encoding = DEFAULT_ENCODING;
		MessageDigest md5 = null;
		md5 = MessageDigest.getInstance("md5");
		md5.update(s.getBytes(encoding));
		byte[] digest = md5.digest();
		StringBuilder sb = new StringBuilder();
		if (digest == null || digest.length < 1)
			return null;
		for (byte b : digest) {
			sb.append(HEXDIGITS[b >>> 4 & 0xf]);
			sb.append(HEXDIGITS[b & 0xf]);
		}
		return sb.toString();
	}
	/**
	 * md5加密，小写
	 */
	public static String getMD5(String s) throws Exception {
		return getMD5(s, DEFAULT_ENCODING);
	}
	/**
	 * 16位md5加密，小写
	 */
	public static String get16MD5(String sourceStr) {  
        String result = "";  
        try {  
            // 生成一个MD5加密计算摘要
            MessageDigest md = MessageDigest.getInstance("MD5");
            // 计算md5函数
            md.update(sourceStr.getBytes());
            // digest()最后确定返回md5 hash值，返回值为8为字符串。因为md5 hash值是16位的hex值，实际上就是8位的字符
            // BigInteger函数则将8位的字符串转换成16位hex值，用字符串来表示；得到字符串形式的hash值
            result = new BigInteger(1, md.digest()).toString(16);
            result = result.substring(8, 24);
        } catch (NoSuchAlgorithmException e) {  
            System.out.println(e);  
        }  
        return result;  
    }  
	/**
	 * hmacMd5加密
	 * 
	 * @param message
	 *            加密内容
	 * @param key
	 * @return
	 */
	public static String hmacMd5(String message, String key) {
		Assert.hasText(message, "message");
		Assert.hasText(key, "key");
		try {
			SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(DEFAULT_ENCODING), "HmacMD5");
			Mac mac = Mac.getInstance(signingKey.getAlgorithm());
			mac.init(signingKey);
			byte[] digest = mac.doFinal(message.getBytes(DEFAULT_ENCODING));
			return HexUtil.toHexString(digest);
		} catch (Exception ex) {
			return "error";
		}
	}
	/**
     * 对字符串加密,加密算法使用MD5,SHA-1,SHA-256,默认使用SHA-256
     * 
     * @param strSrc
     *            要加密的字符串
     * @param encName
     *            加密类型
     * @return
     */
    public static String Encrypt(String strSrc, String encName) {
        MessageDigest md = null;
        String strDes = null;

        byte[] bt = strSrc.getBytes();
        try {
            if (encName == null || encName.equals("")) {
                encName = "SHA-256";
            }
            md = MessageDigest.getInstance(encName);
            md.update(bt);
//            strDes = bytes2Hex(md.digest()); // to HexString
//            System.out.println(bytes2Hex(md.digest()));
            strDes = HexUtil.toHexString(md.digest());
        } catch (NoSuchAlgorithmException e) {
            return null;
        }
        return strDes;
    }

    public static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; i++) {
            tmp = (Integer.toHexString(bts[i] & 0xFF));
            if (tmp.length() == 1) {
                des += "0";
            }
            des += tmp;
        }
        return des;
    }
    private final static String DES = "DES";
	 
    /**
     * Description DES根据键值进行加密
     * @param data 
     * @param key  加密键byte数组
     * @return
     * @throws Exception
     */
    public static String encryptDes(String data, String key) {
    	String result = null;
		try {
			 byte[] bt = encrypt(data.getBytes(), key.getBytes());
//			 result = new BASE64Encoder().encode(bt);
//			 result = DatatypeConverter.printBase64Binary(bt).replaceAll("\r\n", "");
//			 result = DatatypeConverter.printBase64Binary(bt);
		} catch (Exception e) {
			e.printStackTrace();
		}
        return result;
    }
 
    /**
     * Description DES根据键值进行解密
     * @param data
     * @param key  加密键byte数组
     * @return
     * @throws IOException
     * @throws Exception
     */
    public static String decryptDes(String data, String key) throws IOException,
            Exception {
        if (data == null)
            return null;
//        BASE64Decoder decoder = new BASE64Decoder();
//        byte[] buf = decoder.decodeBuffer(data);
//        byte[] buf = DatatypeConverter.parseBase64Binary(data);
//        byte[] bt = decrypt(buf,key.getBytes());
//        return new String(bt);
		return null;
    }
 
    /**
     * Description 根据键值进行加密
     * @param data
     * @param key  加密键byte数组
     * @return
     * @throws Exception
     */
    private static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();
 
        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);
 
        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);
 
        // Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance(DES);
 
        // 用密钥初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, securekey, sr);
 
        return cipher.doFinal(data);
    }
     
     
    /**
     * Description 根据键值进行解密
     * @param data
     * @param key  加密键byte数组
     * @return
     * @throws Exception
     */
    private static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        // 生成一个可信任的随机数源
        SecureRandom sr = new SecureRandom();
 
        // 从原始密钥数据创建DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(key);
 
        // 创建一个密钥工厂，然后用它把DESKeySpec转换成SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES);
        SecretKey securekey = keyFactory.generateSecret(dks);
 
        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance(DES);
 
        // 用密钥初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, securekey, sr);
 
        return cipher.doFinal(data);
    }

//	public static void main(String[] args) throws Exception {
////		String s = SecurityUtil.getMD5("test", "UTF-8");
//		String s = SecurityUtil.Encrypt("qazqaz123", "SHA-1");
//		System.out.println(s);
//
//		String data = "123 456";
//        String key = "wang!@#$%";
//        System.out.println(encryptDes(data, key));
//        System.out.println(decryptDes(encryptDes(data, key), key));
//	}


	public static void main(String[] args) throws UnsupportedEncodingException {
		String str = "eyJpdGVtcyI6W3sicGVyc2lzdGVudElkIjoiMjA1MWNlODhlZGE2MGI3MjQ5ZWM4MGIwZjkwNzFhNjYxOTBmIiwic3RyZWFtbmFtZSI6ImxpdmUtMTIzYXNkYXNkYWEuZmx2Iiwib3BzIjoid3NmcmFtZS9qcGcvaW50ZXJ2YWwvMzAwL3cvNzIwL2gvMzYwfHNhdmVhcy9kM1J1WlhSM2IzSnJkR1Z6ZERBd01Ub2tLSE4wY21WaGJXNWhiV1VwTFNRb2RHbHRaWE4wWVcxd0tRPT0iLCJidWNrZXQiOiJ3dG5ldHdvcmt0ZXN0MDAxIiwiY29kZSI6MSwiZGVzYyI6ImZpbGVPcGVyYXRlQWN0aXZlIiwiZXJyb3IiOm51bGwsImtleXMiOlsid3RuZXR3b3JrdGVzdDAwMTpsaXZlLTEyM2FzZGFzZGFhLS0yMDIxMDYxMDIxMzE0MC5qcGciXSwidXJscyI6WyJodHRwOi8vaW1nLmpuZHh0aWVodWEuY24vbGl2ZS0xMjNhc2Rhc2RhYS0tMjAyMTA2MTAyMTMxNDAuanBnIl0sImRldGFpbCI6W3sia2V5Ijoid3RuZXR3b3JrdGVzdDAwMTpsaXZlLTEyM2FzZGFzZGFhLS0yMDIxMDYxMDIxMzE0MC5qcGciLCJ1cmwiOiJodHRwOi8vaW1nLmpuZHh0aWVodWEuY24vbGl2ZS0xMjNhc2Rhc2RhYS0tMjAyMTA2MTAyMTMxNDAuanBnIiwiZHVyYXRpb24iOjAuMCwiaGFzaCI6IkZxZEpvcFRkT3loMEFTZnQyNEdVRUtPYm9mNU8iLCJmc2l6ZSI6MjYwNDAsInN0YXJ0VGltZSI6IjIwMjEwNjEwMjEzMTQwIiwiZW5kVGltZSI6IjIwMjEwNjEwMjEzMTQwIiwiZW5kVGltZXN0YW1wIjoxNjIzMzMxOTAwLCJzdGFydFRpbWVzdGFtcCI6MTYyMzMzMTkwMCwiYml0X3JhdGUiOm51bGwsInJlc29sdXRpb24iOiI3MjBYMzYwIiwidmNvZGVjX25hbWUiOm51bGx9XSwicHVibGlzaCI6ImxpdmUiLCJjaGFubmVsbmFtZSI6IjEyM2FzZGFzZGFhIn1dLCJiYXRjaF9ub3RpZnlfaWQiOm51bGx9";
//		String res = Base64.getEncoder().encodeToString(str.getBytes("UTF-8"));
//
//		System.out.println(res);

		String restr = new String(Base64.getDecoder().decode(str), "UTF-8");
		System.out.println(str);
		System.out.println(restr);
	}
}