package com.live.common.constant;

import com.live.common.enums.ErrorCode;
import lombok.Data;

import java.io.Serializable;

/**
 * @author a
 * @date 2020/6/4 11:12
 */

@Data
public class ApiResult<T> implements Serializable {


    private static final long serialVersionUID = 5321711398733581757L;

    // 成功码
    private static final String SUCCESS_CODE = "0";

    // 未知错误码
    private static final String ERROR_CODE = "1";

    private String code = SUCCESS_CODE;

    private String message;

    private T data;

    public static final ApiResult SUCCESS = new ApiResult(SUCCESS_CODE);

    public static final ApiResult ERR = new ApiResult(ERROR_CODE);

    public ApiResult() {
    }

    public ApiResult(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public ApiResult(String code, String message) {
        this(code, message, null);
    }

    public ApiResult(String code) {
        this.code = code;
    }

    public ApiResult(String code, T data) {
        this.code = code;
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    /**
     * 是否成功
     * @return
     */
    public boolean resultIsSuccess() {
        return this.code.equalsIgnoreCase(SUCCESS_CODE);
    }

    // 成功静态方法
    public static <T> ApiResult<T> success(T data) {
        return new ApiResult(SUCCESS_CODE, data);
    }

    //失败静态方法
    public static ApiResult error(String code) {
        return new ApiResult(code);
    }

    public static ApiResult error(String code, String message) {
        return new ApiResult(code, message);
    }

    public static <T> ApiResult<T> error(String code, String message, T data) {
        return new ApiResult<T>(code, message, data);
    }

    public static <T> ApiResult<T> error(String code, T data) {
        return new ApiResult<T>(code, null, data);
    }

    public static <T> ApiResult<T> error(ErrorCode errorCode) {
        return new ApiResult<T>(errorCode.getCode(), errorCode.getMsg(), null);
    }

    @Override
    public String toString() {
        return "ApiResult{" +
                "code=" + code +
                ", message='" + message + '\'' +
                ", data=" + data +
                '}';
    }

}
