package com.live.common.domain.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MatchInfoFootballResponse {

    //比赛信息
    private MatchGameInfo matchGameInfo;

    //技术统计
    private List<MatchGameStat> gameStat;

    //赛况
    private List<MatchGoal> matchGoals;

    //一手情报
    private MatchTeamMsg matchTeamMsg;

    //积分榜
    private TeamIntegralDto teamIntegralDto;

    //分析数据
    private List<MatchRecentDto> matchRecentDtos;

    //阵容
//    private List

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchRecentDto {
        private List<String[]> competitionData;
        private String teamRecordLost;
        private String teamRecordName;
        private String teamRecordTie;
        private String teamRecordWin;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamIntegralDto {
        private TeamIntegralInfoDto homeIntegral;
        private TeamIntegralInfoDto awayIntegral;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamIntegralInfoDto {
        private String[] header;
        private String[] integralSum;
        private String[] integralHome;
        private String[] integralAway;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchTeamMsg {
        private TeamMsg homeMsg;
        private TeamMsg awayMsg;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamMsg {
        private String goodMsg;
        private String badMsg;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchGoal {
        private Integer minute;
        //黄牌 进球
        private String eventName;
        //下场人员
        private String downName;
        //上场人员
        private String upName;
        //1 home 2 away
        private int type;
        //主要球员
        private String pName;
        private String score;
        //助攻
        private String assistedName;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchGameStat {
        private String statHome;
        private String statAway;
        private String statName;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchGameInfo {

        @ApiModelProperty("竞赛状态 1 正在进行 2未开始 3完场")
        private int status;
        private String matchDay;
        private String matchTime;
        private Integer sportType;
        private String competitionName;
        private String competitionShortName;
        private TeamMatchInfo teamInfo;

    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamMatchInfo {
        private MatchListInfo awayTeam;

        private MatchListInfo homeTeam;
    }

}
