package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@EqualsAndHashCode(callSuper = true)
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_sports")
public class Sports extends BaseStringIdEntity {
    // 0足球 1篮球
    private int sportsId;
    //类型。足球，篮球等
    private String sportsName;
    private String competitionIcon;
    //短名
    private String competitionShortName;
    //全名
    private String competitionName;
    //英文全名
    private String competitionNameEn;
    //英文短名
    private String competitionShortNameEn;
    //赛事类型（league: 联赛, cup: 杯赛）
    private String competitionType;
    //参加球队的类型（club: 俱乐部, national: 国家队）
    private String teamType;
    //1显示在赛程搜索top上
    private int searchTop;
    //1显示在赛程页面
    private int showMatch;
    //举办国
    private String country;
    //当前赛季
    private String currSeason;
    //参与的所有赛季 , 拼接
    private String seasons;
    //来源ID
    private Integer sourceId;
    //0 Leyu 1 AlStat
    private Integer sourceType;

    //篮球使用 性别类型（male: 男子, female： 女子, youthMale: 青年男子, youthFemale: 青年女子）
    private String gender;
    //篮球使用 比赛常规时间节数
    private Integer quarterNum;
    //篮球使用 每节比赛时间
    private String quarterTime;

    private int sort;
}