package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatScheduleMatchDto {

    private String state;
    private List<AlStatScheduleMatchInfoDto> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatScheduleMatchInfoDto {
        private Integer id;
        private Integer competitionId;
        private String competitionName;
        private String stageName;
        private String startTime;
        private Integer homeTeamId;
        private String homeTeamName;
        private Integer awayTeamId;
        private String awayTeamName;
        //比赛状态（0:未开始, 1:进行中, 2:已结束, 3:延期, 4:中断, 5:取消）
        private Integer status;
        private Integer homeScore;
        private Integer awayScore;
        private Integer winTeamId;
    }

//    “id”: 10001,					//比赛Id
//            “seasonId”: 1,					//赛事赛季Id
//            “competitionId”: 1,				//赛事Id
//            “competitionName”: “NBA”,		//赛事名称
//            “season”: “19/20”,				//赛季
//            “stageId”: 23,					//赛事阶段Id
//            “stageName”: “常规赛”,			//赛事阶段名称
//            “groupId”: 41,					//赛事分组Id
//            “groupName”: “A组”,				//赛事分组名称
//            “startTime”: “2020-01-10 11:30:00”,	//比赛开始时间
//            “roundNum”: “7”,				//比赛轮次
//            “homeTeamId”: 1,				//主队Id
//            “homeTeamName”: “湖人”,			//主队名称
//            “awayTeamId”: 6,				//客队Id
//            “awayTeamName”: “火箭”,			//客队名称
//            “status”: 0,					//比赛状态（0:未开始, 1:进行中, 2:已结束, 3:延期, 4:中断, 5:取消）
//            “quarterNum”: 5,				//比赛节数
//            “homeScore”: 134,				//主队得分
//            “awayScore”: 137,				//客队得分
//            “q1homeScore”: 28,				//第一节主队得分
//            “q1awayScore”: 35,				//第一节客队得分
//            “q2homeScore”: 32,				//第二节主队得分
//            “q2awayScore”: 30,				//第二节客队得分
//            “q3homeScore”: 25,				//第三节主队得分
//            “q3awayScore”: 36,				//第三节客队得分
//            “q4homeScore”: 36,				//第四节主队得分
//            “q4awayScore”: 27,				//第四节客队得分
//            “overTimeNum”: 1,				//加时次数
//            “overTimeScore”: {				//加时比分
//                "ot1homeScore": 13,
//                        "ot1awayScore":9
//            },
//            “winTeamId”: 6,					//获胜球队Id
//            “isNeutral”: 0,					//是否为中立场地
//            “venueId”: 76					//比赛场地

}
