package com.live.common.utils.match;

import com.live.common.domain.entity.Match;

import java.util.HashMap;
import java.util.Map;

public class CommonUtil {

    private static final Map<String, String> positionName;
    private static final Map<String, String> footName;
    private static final Map<String, String> mainPosition;

    static {
        positionName = new HashMap<>();
        positionName.put("Striker","前锋");
        positionName.put("Midfield","中场");
        positionName.put("Defence","后卫");
        positionName.put("Goalkeeper","门将");

        footName = new HashMap<>();
        footName.put("left", "左脚");
        footName.put("right", "右脚");
        footName.put("both", "左右脚");

        mainPosition = new HashMap<>();
        mainPosition.put("Keeper", "门将");
        mainPosition.put("Sweeper", "清道夫");
        mainPosition.put("Centre-Back", "中后卫");
        mainPosition.put("Left-Back", "左后卫");
        mainPosition.put("Right-Back", "右后卫");
        mainPosition.put("Defensive Midfield", "后腰");
        mainPosition.put("Central Midfield", "中场");
        mainPosition.put("Left Midfield", "左中场");
        mainPosition.put("Right Midfield", "右中场");
        mainPosition.put("Attacking Midfield", "前腰");
        mainPosition.put("Left Wing", "左边锋");
        mainPosition.put("Right Winger", "右边锋");
        mainPosition.put("Secondary Striker", "影子前锋");
        mainPosition.put("Centre-Forward", "中锋");
    }

    //根据下注区域判断
    public static boolean winOrLose(Match match, Integer betPosition){
        if(match.getCompetitionStatus() != 3)
            return false;

        return betPosition == winPosition(match);
    }

    public static int winPosition(Match match){
        if(match.getCompetitionStatus() != 3)
            return -1;

        if(match.getHomeScore() > match.getAwayScore()){
            return 0;
        } else if(match.getHomeScore().equals(match.getAwayScore())){
            return 1;
        } else {
            return 2;
        }
    }

    public static String positionZh(String position){
        return positionName.get(position);
    }

    public static String getFootZh(String foot){
        return footName.get(foot);
    }

    public static String getMainPosition(String position){
        return mainPosition.get(position);
    }

//    public static void main(String[] args) {
//        System.out.println(positionZh("1"));
//    }

}
