package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatTeamBasketballStatisticsDto {

    private String state;
    private List<AlStatScheduleMatchInfoDto> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatScheduleMatchInfoDto {
        private List<AlStatStatsInfoDto> stats;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatStatsInfoDto {
        private Integer id;
        private Integer teamId;
        //胜负(0:负,1胜)
        private Integer result;
        private String teamName;
        //主队或客队（home:主队,away:客队）
        private String homeAway;
        private Integer points;
        private Integer losePoints;
        private Integer assists;
        private Integer rebounds;
        private Integer offRebounds;
        private Integer defRebounds;
        private Integer steals;
        private Integer turnovers;
        private Integer blocks;
        private Integer blocksAga;
        private Integer fouls;
        private Integer fouled;
        private Integer fieldGoalsAtt;
        private Integer fieldGoalsMade;
        private Integer fieldGoalsPerc;
        private Integer twoPointsAtt;
        private Integer twoPointsMade;
        private Integer twoPointsPerc;
        private Integer threePointsAtt;
        private Integer threePointsMade;
        private Integer threePointsPerc;
        private Integer freeThrowsAtt;
        private Integer freeThrowsMade;
        private Integer freeThrowsPerc;
    }

//					“id”: 10001,				//数据Id
//            “teamId”: 6,				//球队Id
//            “teamName”: “火箭”,			//球队名称
//            “homeAway”: “home”,			//主队或客队（home:主队,away:客队）
//            “result”: 1,				//胜负(0:负,1胜)
//            “points”: 123,				//得分
//            “losePoints”: 118,			//失分
//            “assists”: 25,				//助攻
//            “rebounds”: 34,				//篮板
//            “offRebounds”: 8,			//进攻篮板
//            “defRebounds”: 26,			//防守篮板
//            “steals”: 11,				//抢断
//            “turnovers”: 12,			//失误
//            “blocks”: 5,				//盖帽
//            “blocksAga”: 7,				//被盖帽
//            “fouls”: 20,				//犯规
//            “fouled”: 19,				//被犯规
//            “fieldGoalsAtt”: 94,		//投篮出手
//            “fieldGoalsMade”: 39,		//投篮命中
//            “fieldGoalsPerc”: 41.49,	//投篮命中率
//            “twoPointsAtt”: 38,			//两分球出手
//            “twoPointsMade”: 19,		//两分球命中
//            “twoPointsPerc”: 50,		//两分球命中率
//            “threePointsAtt”: 56,		//三分球出手
//            “threePointsMade”: 20,		//三分球命中
//            “threePointsPerc”: 35.71,	//三分球命中率
//            “freeThrowsAtt”: 27,		//罚篮出手
//            “freeThrowsMade”: 25,		//罚篮命中
//            “freeThrowsPerc”: 92.59		//罚篮命中率

}
