package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatFootballLeagueRankDto {

    private String state;
    private List<LeagueTable> leagueTables;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class LeagueTable {
        private Integer id;
        private Integer competitionId;
        private String season;
        private Integer teamId;
        private String teamName;
        private Integer groupId;
        private Integer matches;
        private Integer wins;
        private Integer draws;
        private Integer losts;
        private Integer goalFor;
        private Integer goalAga;
        private Integer goalDiff;
        private Integer points;
        private Integer position;
        private String qualificate;

//        			“id”: 1,						//数据Id
//                “competitionId”: 14,			//赛事Id
//                “season”: “19/20”,				//赛季
//                “teamId”: 22,					//球队Id
//                “groupId”: 826,					//赛事分组Id
//                “matches”: 38,					//比赛场次
//                “wins”: 26,						//获胜场次
//                “draws”: 9,						//平局场次
//                “losts”: 3,						//失利场次
//                “goalFor”: 73,					//进球
//                “goalAga”: 32,					//失球
//                “goalDiff”: 43,					//净胜球
//                “points”: 87,					//积分
//                “position”: 1,					//排名
//                “qualificate”: “欧冠”			//入围
    }

}
