package com.live.job.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonStringId;
import com.live.job.constant.CrawlPlatformEnum;
import com.live.job.service.CrawlAnchorService;
import com.live.job.service.CrawlStrategyFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/crawlSequoia")
@Api(tags = "爬取 红杉主播 接口文档")
public class CrawlSequoiaController {

    @Autowired
    private CrawlStrategyFactory crawlStrategyFactory;

    @PostMapping(value = "/crawlSequoiaAnchor")
    @ApiOperation(value = "爬取红衫主播 列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> crawlSequoiaAnchor(HttpServletRequest request) {
        crawlStrategyFactory.getCrawlAnchorService(CrawlPlatformEnum.Sequoia.getCode()).crawlAnchor();
        return ResponseData.successResponse();
    }

    @PostMapping(value = "/crawlSequoiaAnchorById")
    @ApiOperation(value = "爬取红衫主播")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> crawlSequoiaAnchorById(@RequestBody CommonStringId stringId, HttpServletRequest request) {
        crawlStrategyFactory.getCrawlAnchorService(CrawlPlatformEnum.Sequoia.getCode()).crawlAnchorById(stringId.getId());
        return ResponseData.successResponse();
    }

}
