package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FootballCompetitionDto {

    private GameInfo gameInfo;

    private GameGoalData gameGoalData;

    private List<GameState> gameStat;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GameGoalData {
        private List<MatchGoal> MatchGoal;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchGoal {
        //分钟
        private Integer Minute;
        private List<TeamGoal> Away_Goal;
        private List<TeamGoal> Home_Goal;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamGoal {
        private Integer AssistedPid;
        private String AssistedPname;   // "迪诺·恩德洛武"
        private Integer DownID;         //: 99660
        private String Downname;        //: "迪诺·恩德洛武"
        private String Ename;           //: "换人"
        private Integer Event;          //: 13
        private Integer Minute;         //: 79
        private String PSname;          //: "拉斐尔·马丁斯"
        private Integer Pid;            //: 98566
        private String Pname;           //: "拉斐尔·马丁斯"
        private String Score;           //: "0-1"
        private Integer Sort;           //: 9
        private Integer Type;           //: 1
        private Integer UpID;           //: 98566
        private String Upname;          //: "拉斐尔·马丁斯"
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GameInfo {
        private Integer AwayScore;
        private String AwayTeamName;
        private String AwayTeamShortName;

        private String CompetitionName;
        private String CompetitionShortName;

        private Integer HomeScore;
        private String HomeTeamName;
        private String HomeTeamShortName;
        private Integer Status;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GameState {
        private String StatAway;    //48
        private String StatHome;    //52
        private String StatName;    //控球率
    }
}
