package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.MatchLiveConfigRequest;
import com.live.common.domain.request.back.*;
import com.live.common.service.MatchService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

@CrossOrigin
@RestController
@RequestMapping("/match")
@Api(tags = "赛事接口")
public class MatchController {

    @Resource
    private MatchService matchService;

    @PostMapping(value = "/backGetMatchList")
    @ApiOperation(value = "赛事列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> backGetMatchList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
        return matchService.backGetMatchList(commonPage, request);
    }

    @PostMapping(value = "/getSportsList")
    @ApiOperation(value = "获取赛事类型列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getSportsList(HttpServletRequest request){
        return matchService.getSportsList(request);
    }

    @PostMapping(value = "/addMatch")
    @ApiOperation(value = "新增赛程")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> addMatch(@RequestBody AddMatchRequest addMatchRequest, HttpServletRequest request){
        return matchService.addMatch(addMatchRequest, request);
    }

    @PostMapping(value = "/updateMatch")
    @ApiOperation(value = "更新赛程")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> updateMatch(@RequestBody UpdateMatchRequest updateMatch, HttpServletRequest request){
        return matchService.updateMatch(updateMatch, request);
    }

    @PostMapping(value = "/editMatchLiveConfig")
    @ApiOperation(value = "赛事直播源配置")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> matchLiveConfig(@RequestBody MatchLiveConfigRequest matchLiveConfigRequest, HttpServletRequest request){
        return matchService.matchLiveConfig(matchLiveConfigRequest, request);
    }

    @PostMapping(value = "/getMatchLiveConfigList")
    @ApiOperation(value = "赛事直播源配置列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getMatchLiveConfigList(@RequestBody MatchLiveListRequest commonPage, HttpServletRequest request){
        return matchService.getMatchLiveConfigList(commonPage, request);
    }

    @PostMapping(value = "/getHotRankList")
    @ApiOperation(value = "红榜列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getHotRankListBack(@RequestBody HotRankListRequest rankListRequest, HttpServletRequest request){
        return matchService.getHotRankListBack(rankListRequest, request);
    }

    @PostMapping(value = "/editHotRankInfo")
    @ApiOperation(value = "修改 / 新增 红榜")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> editHotRankInfo(@RequestBody EditHotRankInfoRequest rankListRequest, HttpServletRequest request){
        return matchService.editHotRankInfo(rankListRequest, request);
    }

}