package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatBasketballTeamsDto {

    private String state;
    private List<BasketballTeamsDto> teams;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class BasketballTeamsDto {
        private Integer id;
        private String name;
        private String nameFull;
        private String nameEn;
        private String nameEnFull;
        private String teamType;
        private String gender;
        private Integer leagueId;
        private Integer areaId;
        private String city;
        private String founded;
        private String website;
        private String venueId;

//“id”: 1,						//球队Id
//                “name”: “湖人”,					//球队名称（简称）
//                “nameFull”: “洛杉矶湖人”,		//球队名称（全称）
//                “nameEn”: “Lakers”,				//球队英文名称（简称）
//                “nameEnFull”: “Los Angeles Lakers”,	//球队英文名称（全称）
//                “teamType”: “club”,				//球队类型（club: 俱乐部, national: 国家队）
//                “gender”: “male”,				//性别类型（male: 男子, female： 女子, youthMale: 青年男子, youthFemale: 青年女子）
//                “leagueId”: 1,					//参加联赛Id
//                “areaId”: 193,					//球队所在国家
//                “city”: “洛杉矶”,				//所在城市
//                “website”: “”,					//官网网址
//                “founded”: “1964”,				//成立时间
//                “venueId”: 18					//主场球馆
    }

}
