package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.SysRoleDTO;
import com.live.common.domain.request.back.RoleVO;
import com.live.common.service.ISysRoleService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


@CrossOrigin
@RestController
@RequestMapping("/sys/role")
public class SysRoleController {

    @Resource
    private ISysRoleService iSysRoleService;

    @PostMapping
    @ApiOperation("新增角色")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> save(@RequestBody RoleVO sysRoleDTO) {
        return iSysRoleService.save(sysRoleDTO);
    }

    @PostMapping("updateRole")
    @ApiOperation("修改角色")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> update(@RequestBody SysRoleDTO sysRoleDTO) {
        return iSysRoleService.update(sysRoleDTO);
    }

    //TODO 角色详情
    @PostMapping("detail")
    @ApiOperation("角色详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> findRole(@RequestParam Integer roleId) {
        return iSysRoleService.getSysRoleDetail(roleId);
    }

    @PostMapping("list")
    @ApiOperation("角色列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> findRoleList() {
        return iSysRoleService.getSysRoleList();
    }

}
