package com.live.common.domain;

import lombok.Data;

import java.io.Serializable;

@Data
public class ResponseData<T> implements Serializable {

    public final static int SUCCESS = 200;

    private int code;
    private String msg;
    private T data;

    public static ResponseData successResponse(Object data) {
        ResponseData<Object> success = new ResponseData<>();
        success.setCode(SUCCESS);
        success.setData(data);
        return success;
    }

    public static ResponseData successResponse(int code, Object data) {
        ResponseData<Object> success = new ResponseData<>();
        success.setCode(code);
        success.setData(data);
        return success;
    }

    public static ResponseData successResponse() {
        ResponseData<Object> success = new ResponseData<>();
        success.setCode(SUCCESS);
        success.setMsg("SUCCESS");
        return success;
    }

    public static ResponseData failResponse() {
        ResponseData<Object> fail = new ResponseData<>();
        fail.setCode(500);
        fail.setMsg("服务器异常,请咨询客服");
        return fail;
    }

    public static ResponseData failResponse(ResponseStatusEnum responseStatusEnum) {
        ResponseData<Object> fail = new ResponseData<>();
        fail.setCode(responseStatusEnum.getCode());
        fail.setMsg(responseStatusEnum.getName());
        return fail;
    }

    public static ResponseData fail400Response(String msg) {
        ResponseData<Object> fail = new ResponseData<>();
        fail.setCode(400);
        fail.setMsg(msg);
        return fail;
    }

    public static ResponseData fail500Response(String msg) {
        ResponseData<Object> fail = new ResponseData<>();
        fail.setCode(500);
        fail.setMsg(msg);
        return fail;
    }

    public static ResponseData failResponse(int code, String msg) {
        ResponseData<Object> fail = new ResponseData<>();
        fail.setCode(code);
        fail.setMsg(msg);
        return fail;
    }

}
