package com.live.common.domain.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@Data
public class UpdatePhoneByAppRequest {

    @NotBlank(message = "请输入短信验证码")
    @Size(max = 6, min = 6, message = "请输入6位短信验证码")
    @ApiModelProperty(value = "短信验证码")
    private String smsCode;

    @NotBlank(message = "请输入手机号")
    @Size(max = 11, min = 11, message = "请输入11位手机号")
    @ApiModelProperty(value = "手机号")
    private String phone;

}
