package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatFootballScoreDto {

    private String state;
    private List<LiveScores> liveScores;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class LiveScores {
        private Integer id;
        private Integer matchId;
        private String elapsed;
        private Integer status;
        private Integer period;
        private String score;
        private Integer winTeamId;

//        “id”: 1,						//数据Id
//                “matchId”: 10001,				//比赛Id
//                “elapsed”: “56’”,				//比赛进行时间（显示分钟数，上半场结束显示HT，下半场结束显示FT，加时赛上半场显示ET1，加时赛下半场显示ET2，加时赛结束显示AET，点球大战显示PEN，中断显示Abd，延期显示Post，取消显示Can）
//                “status”: 1,				//比赛状态（0:未开始, 1：比赛中, 2:已结束）
//                “period”: 3,				//比赛时间段（0:赛前, 1:上半场, 2:中场休息, 3:下半场, 4:加时赛上半场, 5:加时赛下半场, 6:点球大战, 7:已结束）
//                “score”: “1 : 0”,				//当前比分（出现点球大战的比赛会以*标注获胜球队，例如*1 : 1或者1 : 1*）
//                “halfTimeScore”: “0 : 0”,		//半场比分
//                “fullTimeScore”: “1 : 0”,		//常规时间比分
//                “extraTimeScore”: “”,			//加时赛比分（为空表示没有加时赛）
//                “penalScore”: “”,				//点球大战比分（为空表示没有点球大战）
//                “winTeamId”: 13,				//获胜球队Id（比赛未结束时为null，比赛结束双方战平时为null）
//                “homeTeamRedNum”: “0”,			//主队红牌数
//                “awayTeamRedNum”: “1”			//客队红牌数
    }

}
