package com.live.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.domain.entity.CrawlHistory;
import com.live.common.domain.entity.Room;
import com.live.common.domain.entity.User;
import com.live.common.domain.request.HXRoomRequest;
import com.live.common.mapper.CrawlHistoryMapper;
import com.live.common.mapper.RoomMapper;
import com.live.common.mapper.UserMapper;
import com.live.common.service.HuanXinIMService;
import com.live.common.service.UserService;
import com.live.common.utils.IdGen;
import com.live.common.utils.MD5Util;
import com.live.job.constant.CrawlPlatformEnum;
import com.live.job.entity.dto.CrawlAnchorSequoiaDto;
import com.live.job.entity.dto.CrawlAnchorSequoiaInfoDto;
import com.live.job.entity.dto.CrawlUUQiuAnchorDto;
import com.live.job.service.CrawlAnchorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.time.Instant;
import java.util.Collections;
import java.util.List;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Slf4j
@Service
public class CrawlSequoiaAnchorServiceImpl implements CrawlAnchorService {

    @Resource
    private UserMapper userMapper;
    @Resource
    private RoomMapper roomMapper;
    @Lazy
    @Autowired
    private UserService userService;
    @Resource
    private RestTemplate restTemplate;
    @Lazy
    @Autowired
    private HuanXinIMService huanXinIMService;
    @Resource
    private CrawlHistoryMapper crawlHistoryMapper;
    @Resource
    private ThreadPoolTaskScheduler taskScheduler;

    private final HttpHeaders headers;

    private final String crawlListUrl = "http://hszb.cc/home/live-data";
    private final String anchorUrl = "http://hszb.cc/home/live";

    public CrawlSequoiaAnchorServiceImpl() {
        headers = new HttpHeaders();
        headers.add("User-Agent", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Mobile Safari/537.36");
        headers.add("Connection", "keep-alive");
        headers.setAccept(Collections.singletonList(APPLICATION_JSON));
    }

    @Override
    public void crawlAnchor() {
        try {
            ResponseEntity<String> response = restTemplate.exchange(crawlListUrl, HttpMethod.GET,
                    new HttpEntity<>(null, headers), String.class);

            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            CrawlAnchorSequoiaDto anchorSequoiaDto = JSONArray.parseObject(jsonObject.getString("data"), CrawlAnchorSequoiaDto.class);
            if (anchorSequoiaDto != null) {
                //分页
                for (int i = 1; i <= anchorSequoiaDto.getPage_data().getPage_count(); i++) {
                    ResponseEntity<String> pageResponse = restTemplate.exchange(crawlListUrl + "?page=" + i, HttpMethod.GET,
                            new HttpEntity<>(null, headers), String.class);

                    JSONObject jsonPageObject = JSONObject.parseObject(pageResponse.getBody());
                    CrawlAnchorSequoiaDto anchorSequoiaPageDto = JSONArray.parseObject(jsonPageObject.getString("data"), CrawlAnchorSequoiaDto.class);
                    for (CrawlAnchorSequoiaDto.AnchorSequoiaInfo sequoiaInfo : anchorSequoiaPageDto.getList_data()) {
                        try {
                            crawlAnchorById(sequoiaInfo.getUser_id());
                        } catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateAnchor(String userId, String roomId) {
        String crawlUrl = anchorUrl + "?id=" + userId;
        ResponseEntity<String> response = restTemplate.exchange(crawlUrl, HttpMethod.GET,
                new HttpEntity<>(null, headers), String.class);

        JSONObject jsonObject = JSONObject.parseObject(response.getBody());
        CrawlAnchorSequoiaInfoDto anchorInfo = JSONArray.parseObject(jsonObject.getString("data"), CrawlAnchorSequoiaInfoDto.class);
        log.info("更新主播:{} \nroomId: {} \n json: {} \n crawlUrl:{}", userId, roomId, JSON.toJSONString(anchorInfo), crawlUrl);
        if (anchorInfo == null || anchorInfo.getLive_info() == null) {
            Room room = roomMapper.selectById(roomId);
            if (room.getType() == 1) {
                room.setType(0);
                roomMapper.updateById(room);

                CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
                        .eq(CrawlHistory::getCrawlUrl, crawlUrl)
                );
                if (crawlHistory != null) {
                    crawlHistoryMapper.deleteById(crawlHistory.getId());
                }
                            }
        } else {
            log.info("更新主播房间状态{}", userId);
            Room room = roomMapper.selectById(roomId);
            String md5 = MD5Util.string2MD5(anchorInfo.getLive_info().toString());
            if (!md5.equals(room.getLastUpMd5())) {
                log.trace("md5不一致更新房间信息 {} - {} - {}", room.getHuanXinRoomId(), md5, room.getLastUpMd5());
                room.setRoomName(anchorInfo.getLive_info().getRoom_name());
                room.setLiveUrl(anchorInfo.getLive_info().getM3u8_url());
                room.setRoomCover(anchorInfo.getLive_info().getPage_img());
//                room.setAnnouncement(anchorInfo.getLive_info().getNotice());
                room.setLastUpMd5(md5);
                roomMapper.updateById(room);
                log.trace("live_info: {}", anchorInfo.getLive_info().toString());
            }

//            taskScheduler.schedule(() -> updateAnchor(userId, roomId), Instant.now().plusSeconds(2 * 60));
        }
    }

    @Override
    public void updateAllAnchor() {
        List<Room> roomList = roomMapper.selectList(Wrappers.<Room>lambdaQuery()
                .eq(Room::getType, 1)
                .eq(Room::getDeleted, 0)
                .eq(Room::getSource, 1)
        );

        for (Room room : roomList) {
            taskScheduler.schedule(() -> updateAnchor(room.getUserId(), room.getHuanXinRoomId()), Instant.now().plusSeconds(30));
        }
    }

    @Override
    public String getPlatform() {
        return CrawlPlatformEnum.Sequoia.getCode();
    }

    //房间详情
    @Override
    @Transactional
    public synchronized void crawlAnchorById(String userId) {
        String crawlUrl = anchorUrl + "?id=" + userId;
//        CrawlHistory crawlHistory = crawlHistoryMapper.selectOne(Wrappers.<CrawlHistory>lambdaQuery()
//                .eq(CrawlHistory::getCrawlUrl, crawlUrl)
//        );
//        if (crawlHistory != null) {
//            return;
//        }

        ResponseEntity<String> response = restTemplate.exchange(crawlUrl, HttpMethod.GET,
                new HttpEntity<>(null, headers), String.class);

        JSONObject jsonObject = JSONObject.parseObject(response.getBody());
        CrawlAnchorSequoiaInfoDto anchorInfo = JSONArray.parseObject(jsonObject.getString("data"), CrawlAnchorSequoiaInfoDto.class);

        if(anchorInfo.getLive_info() == null){
            log.error("{} -> 已下播", anchorInfo.getAnchor().getId());
            return;
        }

        int hots = Integer.parseInt(anchorInfo.getAnchor().getHots());
        User anchor = userMapper.selectById(userId);
        if (anchor == null) {
            User user = User.builder()
                    .id(userId)
                    .userIcon(anchorInfo.getAnchor().getAvatar())
                    .userName(anchorInfo.getAnchor().getNick_name())
                    .userDesc(anchorInfo.getAnchor().getSignature())
                    .sex(anchorInfo.getAnchor().getSex() + 1)
                    .type(1)
                    .role(0)
                    .build();
            userService.createUser(user, null);
            log.trace("爬取红杉 新主播 新增成功");
        }

        Room room = roomMapper.selectOne(Wrappers.<Room>lambdaQuery()
                .eq(Room::getUserId, userId)
        );
        Integer roomType = anchorInfo.getLive_info().getM3u8_url().contains(".fly") ? 0 : 1;
        if (room == null) {
            String roomNum = null;
            do {
                roomNum = IdGen.randomLong(5);
            } while (roomMapper.selectCount(Wrappers.<Room>lambdaQuery()
                    .eq(Room::getRoomNum, roomNum)
            ) > 0);

            String userName = "live_" + userId;
            String huanXinRoomId = huanXinIMService.createRoom(HXRoomRequest.builder()
                    .description(anchorInfo.getLive_info().getNotice())
                    .name(anchorInfo.getLive_info().getRoom_name())
                    .owner(userName)
                    .build());

            int categoryId = 4;
            if ("篮球".equals(anchorInfo.getLive_info().getCategory_name())) {
                categoryId = 3;
            } else if ("足球".equals(anchorInfo.getLive_info().getCategory_name())) {
                categoryId = 2;
            }

            Room saveRoom = Room.builder()
                    .huanXinRoomId(huanXinRoomId)
                    .liveUrl(anchorInfo.getLive_info().getM3u8_url())
                    .roomNum(roomNum)
                    .roomCover(anchorInfo.getLive_info().getPage_img())
//                    .announcement(anchorInfo.getLive_info().getNotice())
                    .announcement("下载红杉直播APP，观看更多精彩足球赛事 下载红杉APP，每天主播陪你一起激情观赛！ 关注主播，每天精彩赛程一路惊喜！")
                    .roomName(anchorInfo.getLive_info().getRoom_name())
                    .type(roomType)
                    .hotNum(hots)
                    .userId(userId)
                    .categoryId(categoryId)
                    .source(1)
                    .build();
            roomMapper.insert(saveRoom);
            log.trace("转换后数据: {}", JSON.toJSONString(anchorInfo.getLive_info()));
            log.trace("爬取红杉 新房间 新增成功 - {}", JSON.toJSONString(saveRoom));
//            crawlHistoryMapper.insert(CrawlHistory.builder().crawlUrl(crawlUrl).build());
            //追踪更新房间状态
            taskScheduler.schedule(() -> updateAnchor(userId, huanXinRoomId), Instant.now().plusSeconds(2 * 60));
        } else if(room.getDeleted() == 0){
            if (!room.getLiveUrl().equals(anchorInfo.getLive_info().getM3u8_url())) {
                int categoryId = 4;
                if ("篮球".equals(anchorInfo.getLive_info().getCategory_name())) {
                    categoryId = 3;
                } else if ("足球".equals(anchorInfo.getLive_info().getCategory_name())) {
                    categoryId = 2;
                }

                room.setLiveUrl(anchorInfo.getLive_info().getM3u8_url());
                room.setRoomCover(anchorInfo.getLive_info().getPage_img());
//                room.setAnnouncement(anchorInfo.getLive_info().getNotice());
                room.setType(roomType);
                room.setRoomName(anchorInfo.getLive_info().getRoom_name());
                room.setHotNum(hots);
                room.setCategoryId(categoryId);
                room.setSource(1);
                roomMapper.updateById(room);
                log.info("房间信息变更，更新房间 {}", room.getUserId());
            } else if(room.getType() == 0){
                room.setType(1);
                roomMapper.updateById(room);
            }

            //追踪更新房间状态
//            taskScheduler.schedule(() -> updateAnchor(userId, room.getHuanXinRoomId()), Instant.now().plusSeconds(2 * 60));
        }
    }
}
