package com.live.common.service;

import com.live.common.domain.ResponseData;
import com.live.common.domain.entity.User;
import com.live.common.domain.request.*;
import com.live.common.domain.request.back.BackGetUserRequest;
import com.live.common.domain.request.back.CreateAccountRequest;
import com.live.common.domain.request.back.EditApplyAnchorRequest;
import com.live.common.domain.request.back.EditUserInfoBackRequest;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;

public interface UserService {

    ResponseData<?> sendSms(SendSmsRequest sendSmsRequest, HttpServletRequest request);

    ResponseData<?> register(RegisterRequest registerRequest, HttpServletRequest request);

    ResponseData<?> userInfoById(UserInfoByIdRequest ids,HttpServletRequest request);

    ResponseData<?> registerByPc(RegisterPcRequest registerRequest, HttpServletRequest request);

    ResponseData<?> loginByPc(LoginPcRequest loginPcRequest, HttpServletRequest request);

    ResponseData<?> forgotPassword(ForgotPasswordRequest forgotPasswordRequest, HttpServletRequest request);

    ResponseData<?> loginOut(HttpServletRequest request);

    ResponseData<?> userInfo(HttpServletRequest request);

    ResponseData<?> editUserInfo(EditUserInfoRequest userInfoRequest, HttpServletRequest request);

    ResponseData<?> editUserAvatar(EditUserAvatarRequest avatarRequest, HttpServletRequest request);

    ResponseData<?> getFeedbackList();

    ResponseData<?> userFeedback(FeedbackRequest feedbackRequest, HttpServletRequest request);

    ResponseData<?> getUserFeedbackList(HttpServletRequest request);

    ResponseData<?> userApplyAnchor(UserApplyAnchorRequest userApplyAnchorRequest, HttpServletRequest request);

    ResponseData<?> updatePhoneSt(UpdatePhoneStRequest loginPcRequest, HttpServletRequest request);

    ResponseData<?> updatePhoneNd(UpdatePhoneNdRequest loginPcRequest, HttpServletRequest request);

    ResponseData<?> updatePhoneByApp(UpdatePhoneByAppRequest loginPcRequest, HttpServletRequest request);

    User registerByDeviceId(String deviceId, String ip);

    void createUser(User accountDb, String deviceId);

    User getRandomAuthor();

    ResponseData<?> getUserMsgList(CommonPage commonPage, HttpServletRequest request);

    ResponseData<?> updateMsgStatus(UserMsgRequest userMsgRequest, HttpServletRequest request);

    //back console
    ResponseData<?> getUserList(BackGetUserRequest getUserRequest, HttpServletRequest request);

    ResponseData<?> editUserInfoBack(EditUserInfoBackRequest editUserInfoRequest, HttpServletRequest request);

    ResponseData<?> delUserById(CommonStringId stringId, HttpServletRequest request);

    ResponseData<?> userApplyAnchorList(CommonPage commonPage, HttpServletRequest request);

    ResponseData<?> editUserApply(EditApplyAnchorRequest applyAnchorRequest, HttpServletRequest request);

    ResponseData<?> createAccount(CreateAccountRequest accountRequest);

}
