package com.live.common.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("t_download_address")
public class DownloadAddress {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 创建人
     */
    private String  createBy;
    /**
     * '创建时间'
     */
    private Date createTime;
    /**
     * '更新时间'
     */
    @TableField(value="update_time")
    private Date updateTime;
    /**
     * '是否删除' 默认0未删除
     */
    private Integer  deleted;

    /**
     * 设备 1.安卓 2.ios 3.其他
     */
    private  Integer device;

    /**
     * 下载地址
     */
    private String adress;

    /**
     * h5推广地址
     */
    private String shareAdress;

    /**
     * 版本
     */
    private String version;

    /**
     * 是否强制更新
     */
    @TableField(value="is_force")
    private Integer isForce;

    /**
     * 描述
     */
    private  String descr;

    /**
     * 渠道,0-必须是官方推广组,其他推广组分别为1,2,3,4,5
     */
    private  String channel;

    /**
     * 推广组名称
     */
    private String channelName;

    /**
     * app下载次数
     */
    private Integer downloadNums;

}
