package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatPlayerFootballStatisticsDto {

    private String state;
    private List<AlStatScheduleMatchFootballInfoDto> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatScheduleMatchFootballInfoDto {
        private Integer homeTeamId;
        private Integer awayTeamId;
        private List<AlStatStatsInfoFootballDto> stats;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatStatsInfoFootballDto {
        private Integer id;
        private Integer teamId;
        //球员Id
        private Integer playerId;
        //球员名称
        private String playerName;
        //主队或客队（home:主队,away:客队）
        private String homeAway;
        //球衣号码
        private Integer shirtNo;
        //场上位置
        private String position;
        //是否首发 1
        private Integer isFirstEleven;

    }


//    {
//	“state”: “success”,			//请求状态，success为成功，error为失败
//	“errorCode”: “10001”,		//错误码（当state为error时返回此属性，否则不返回）
//	“errorMsg”: “请求地址错误”,	//错误信息（当state为error时返回此属性，否则不返回）
//	“matchs”: [					//比赛集合
//        {
//			“id”: 10001,				//比赛Id
//			“startTime”: “2019-01-10 01:30:00”,	//比赛开始时间
//			“homeTeamId”: 13,			//主队Id
//			“homeTeamName”: “利物浦”,	//主队名称
//			“awayTeamId”: 12,			//客队Id
//			“awayTeamName”: “阿森纳”,	//客队名称
//			“stats”: [					//实时球员数据集合
//            {
//					“id”: 10001,				//数据Id
//					“teamId”: 13,				//球队Id
//					“playerId”: 25,				//球员Id
//					“playerName”: “萨拉赫”,		//球员名称
//					“homeAway”: “home”,			//主队或客队（home:主队,away:客队）
//					“isFirstEleven”: 1,			//是否首发（0:否,1:是）
//					“isManOfTheMatch”: 0,		//是否当场最佳
//					“position”: “FW”,			//场上位置（具体定义参考文件-个别名词解释）
//					“positionCoord”: “{\"vertical\":2.5,\"horizontal\":6.5}”,		//位置坐标
//					“shirtNo”: 11,				//球衣号码
//					“subbedInPlayerId”: 77,		//替补上场球员Id
//					“subbedOutPeriod”: 2,		//替补下场比赛阶段（具体定义参考文件-个别名词解释）
//					“subbedOutExpandedMinute”: 67,	//替补下场时间
//					“subbedInPeriod”: null,		//替补上场比赛阶段（具体定义参考文件-个别名词解释）
//					“subbedInExpandedMinute”,	//替补上场时间
//					“subbedOutPlayerId”,		//替换下场球员Id
//					“rate”: 8.69,				//球员评分
//					“goals”: 2,					//进球
//					“assists”: 0,				//助攻
//					“ownGoals”: 0,				//乌龙球
//					“penaltyScored”: 0,			//点球得分
//					“penaltyMissd”: 0,			//射失点球
//					“penaltySaved”: 0,			//扑出点球
//					“yelCards”: 0,				//黄牌
//					“redCards”: 0,				//红牌
//					“shots”: 2,					//射门
//					“shotsOT”: 2,				//射正
//					“shotsOffTag”: 0,			//射偏次数
//					“shotsBlocked”: 0,			//射门被封堵次数
//					“shotsOnPost”: 0,			//击中门框
//					“keyPasses”: 1,				//关键传球
//					“dribbles”: 3,				//过人
//					“dribblesAttempted”: 5,		//尝试过人次数
//					“dribbledPast”: 0,			//被突破
//					“fouled”: 0,				//被侵犯
//					“offsides”: 0,				//越位
//					“disp”: 3,					//被抢断
//					“unsTouches”: 9,			//失误
//					“tackles”: 1,				//抢断
//					“tacklesAttempted”: 1,		//尝试抢断次数
//					“interceptions”: 0,			//拦截
//					“clearances”: 1,			//解围
//					“blockShots”: 0,			//封堵射门
//					“fouls”: 1,					//犯规
//					“fatalError”: 0,			//致命失误导致丢球
//					“seriousError”: 0,			//失误导致被射门
//					“offsideWon”: 0,			//造越位
//					“passes”: 27,				//传球次数
//					“passSucc”: 77.78,			//传球成功率（百分比）
//					“crosses”: 3,				//传中次数
//					“accCrosses”: 2,			//准确传中次数
//					“longBall”: 0,				//长传次数
//					“accLB”: 0,					//准确长传次数
//					“thBall”: 0,				//直塞次数
//					“accThB”: 0,				//准确直塞次数
//					“aerialsWon”: 0,			//争顶成功次数
//					“aerialsTotal”: 1,			//争顶次数
//					“defensiveAerials”: 0,		//防守对抗次数
//					“offensiveAerials”: 1,		//进攻对抗次数
//					“touches”: 55,				//触球
//					“bigChanceMissed”: 0,		//错失绝佳机会次数
//					“bigChanceScored”: 2,		//把握绝佳机会次数
//					“bigChanceCreated”: 0,		//创造绝佳机会次数
//					“ballRecovery”: 5,			//夺回球权
//					“lastManTackle”: 0,			//最后一道防线抢断成功
//					“clearOffLine”: 0,			//门线救险
//					“defensiveThirdPass”: 2,			//后场传球次数
//					“defensiveThirdPassAcc”: 2,			//后场准确传球次数
//					“midThirdPass”: 8,					//中场传球次数
//					“midThirdPassAcc”: 8,				//中场准确传球次数
//					“finalThirdPass”: 17,				//前场传球次数
//					“finalThirdPassAcc”: 11,			//前场成功传球次数
//					“corners”: 4,				//角球次数
//					“accCorners”: 3,			//准确角球次数
//					“claimsHigh”: 1,			//摘高空球次数
//					“totalSaves”: 3				//扑救次数

}
