package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CrawlAnchorSequoiaInfoDto {

    private Integer live_id;

    private AnchorSequoiaInfo anchor;

    private LiveInfo live_info;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class LiveInfo {
        //足球 篮球
        private String category_name;
        private String encrypt_m3u8_url;
        private String m3u8_url;
        private String notice;
        private String page_img;
        //0正在直播
        private Integer play_type;
        private String room_name;
        private Integer match_list_id;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AnchorSequoiaInfo {
        private String avatar;
        private Integer fans;
        private String hots;
        private Integer id;
        private String nick_name;
        //0男 1女
        private Integer sex;
        private String signature;
    }

}
