package com.live.common.domain.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MatchFootballOddsResponse {

    @ApiModelProperty("各家公司指数")
    private List<CompanyInfoZuQiu> companyInfos;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CompanyInfoZuQiu {
        @ApiModelProperty("公司名称")
        private String companyName;
        @ApiModelProperty("公司所属国家")
        private String country;
        //欧赔
        @ApiModelProperty("欧指 / 欧赔")
        private OuZhiOddsInfo ouZhi;
        //亚赔
        @ApiModelProperty("让分")
        private YaZhiOddsZuQiuInfo yaZhi;
        //大小球
        @ApiModelProperty("大小球")
        private DaXiaoOddsInfo daXiao;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class OuZhiOddsInfo {
        //0: 初盘
        private FootballOdds initialOdds;
        //1: 即时盘
        private FootballOdds nowOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FootballOdds {
        @ApiModelProperty("初 / 即")
        private String type;
        @ApiModelProperty("主胜赔率")
        private Double win;
        @ApiModelProperty("平局赔率")
        private Double draw;
        @ApiModelProperty("客胜赔率")
        private Double loss;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class YaZhiOddsZuQiuInfo {
        //0: 初盘
        private FootballYaZhiOdds initialOdds;
        //1: 即时盘
        private FootballYaZhiOdds nowOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FootballYaZhiOdds {
        private String type;
        @ApiModelProperty("让球")
        private Double handicap;
        @ApiModelProperty("主队赔率")
        private Double home;
        @ApiModelProperty("客队赔率")
        private Double away;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class DaXiaoOddsInfo {
        //0: 初盘
        private FootballDaXiaoOdds initialOdds;
        //1: 即时盘
        private FootballDaXiaoOdds nowOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class FootballDaXiaoOdds {
        private String type;
        @ApiModelProperty("盘口")
        private Double handicap;
        @ApiModelProperty("大球赔率")
        private Double over;
        @ApiModelProperty("小球赔率")
        private Double under;
    }
}
