package com.live.common.domain.dto.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MatchListResponse {

    private List<MatchResponse> matchLists;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchResponse {
        //yyyy-MM-dd
        private String matchTime;

        private List<MatchInfoResponse> matchInfos;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchInfoResponse {
        private String id;
        private Integer status;
        private String matchDate;
        private String matchTime;
        private String matchName;
        private String matchShortName;
        private Integer sportsType;
        //是否订阅
        private boolean subscribe;

        private TeamResponse homeTeam;
        private TeamResponse awayTeam;

        private Integer homeScore;
        private Integer awayScore;
        //讲解员 主播
        private List<GuideResponse> guides;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class GuideResponse {
        private String id;
        private String name;
        private String roomId;
        private String avatar;
        //是否正在直播 0 不在 1 在
        private Integer status;
        //0不推荐 1推荐
        private Integer recommend;
        private String matchCutImg;
    }
}
