package com.live.job.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MatchManager {

    private final static MatchManager instance = new MatchManager();

    public static MatchManager getInstance() {
        return instance;
    }

    private MatchManager() {
    }

    private final Map<String, Long> matchIdAndTime = new ConcurrentHashMap<>();

    public boolean existMatchEvent(String matchId){
        return matchIdAndTime.containsKey(matchId);
    }

    public void removeMatchEvent(String matchId){
        matchIdAndTime.remove(matchId);
    }

    public Long getMatchEvent(String matchId){
        return matchIdAndTime.get(matchId);
    }

    public void putMatchEvent(String matchId, long time){
        matchIdAndTime.put(matchId, time);
    }

}
