package com.live.common.domain.dto.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MatchBasketballOddsResponse {

    @ApiModelProperty("各家公司指数")
    private List<CompanyInfo> companyInfos;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CompanyInfo {

        @ApiModelProperty("公司名称")
        private String companyName;
        @ApiModelProperty("公司所属国家")
        private String country;
        //欧赔
        @ApiModelProperty("欧指 / 欧赔")
        private OuZhiOddsInfo ouZhi;
        //让分
        @ApiModelProperty("让分")
        private YaZhiOddsInfo ranFen;
        //大小球
        @ApiModelProperty("大小球")
        private DaXiaoOddsInfo daXiao;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class OuZhiOddsInfo {
        //0: 初盘
        @ApiModelProperty("初盘")
        private BasketballOdds initialOdds;
        //1: 即时盘
        @ApiModelProperty("即时盘")
        private BasketballOdds nowOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class BasketballOdds {
        @ApiModelProperty("初 / 即")
        private String type;
        @ApiModelProperty("主胜赔率")
        private Double win;
        @ApiModelProperty("客胜赔率")
        private Double loss;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class YaZhiOddsInfo {
        //0: 初盘
        @ApiModelProperty("初盘")
        private BasketballYaZhiOdds initialOdds;
        //1: 即时盘
        @ApiModelProperty("即时盘")
        private BasketballYaZhiOdds nowOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class BasketballYaZhiOdds {
        private String type;
        @ApiModelProperty("让球")
        private Double handicap;
        @ApiModelProperty("主队赔率")
        private Double home;
        @ApiModelProperty("客队赔率")
        private Double away;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class DaXiaoOddsInfo {
        //0: 初盘
        private BasketballDaXiaoOdds initialOdds;
        //1: 即时盘
        private BasketballDaXiaoOdds nowOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class BasketballDaXiaoOdds {
        private String type;
        @ApiModelProperty("盘口")
        private Double handicap;
        @ApiModelProperty("大分赔率")
        private Double over;
        @ApiModelProperty("小分赔率")
        private Double under;
    }
}
