package com.live.common.domain.dto.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TeamAllInfoResponse {

    private TeamInfoResponse teamInfo;
    private List<TeamPlayerInfoResponse> teamPlayers;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamPlayerInfoResponse {
        private Integer id;
        private String name;
        private String nameEn;
        private String country;
        private String birthday;
        private String height;
        private String rnNumber;
        private String marketValue;
        private String position;
        private String icon;
    }


    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamInfoResponse {
        private String id;
        private String teamName;
        private String teamNameEn;
        private String sportsName;
        private String teamType;
        private String country;
        private String teamIcon;
    }

}
