package com.live.common.domain.request.back;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DownloadAddressDTO implements Serializable {

    private Integer id;

    /**
     * 设备 1.安卓 2.ios 3.其他
     */
    @ApiModelProperty("设备")
    private  Integer device;

    /**
     * 下载地址
     */
    @ApiModelProperty("下载地址")
    private String adress;

    /**
     * h5推广地址
     */
    @ApiModelProperty("h5推广地址")
    private String shareAdress;

    /**
     * 版本
     */
    @ApiModelProperty("版本")
    private String version;

    /**
     * 是否强制更新
     */
    @ApiModelProperty("0-不强制,1-强制更新")
    private Integer isForce;

    @ApiModelProperty("更新内容描述")
    private String descr;

    @ApiModelProperty("推广组名称")
    private String channelName;

    @ApiModelProperty("app下载次数")
    private Integer downloadNums;

    @ApiModelProperty("是否禁用")
    private Integer deleted;

}
