package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatMatchStageScoreDto {

    private String state;

    private List<AlStatMatchStageScoreInfoDto> liveScores;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatMatchStageScoreInfoDto {
        private Integer matchId;
        private String timeStamp;
        //比赛状态（0:未开始, 1:比赛中, 2:已结束, 3:延期, 4:中断, 5:取消）
        private Integer status;
        //比赛时间段（0:赛前, 1:第一节, 2:第二节, 3:第三节, 4:第四节, 5:加时赛, 6:已结束）
        private Integer period;
        //当前节剩余时间
        private String quarterRemainTime;
        //比赛节数
        private Integer quarterNum;
        //主队得分
        private Integer homeScore;
        //客队得分
        private Integer awayScore;
        //第一节主队得分
        private Integer q1homeScore;
        private Integer q2homeScore;
        private Integer q3homeScore;
        private Integer q4homeScore;
        //加时次数
        private Integer overTimeNum;
        //加时比分
        private List<String> overTimeScore;
        //第一节客队得分
        private Integer q1awayScore;
        private Integer q2awayScore;
        private Integer q3awayScore;
        private Integer q4awayScore;
    }

}
