package com.live.common.utils;

/**
 * @Author: bob
 * @Date: 2020/6/20 13:17
 * @Version 1.0
 */

import java.util.UUID;

/**
 * 上传图片
 */
public class FileNameUtils {


    /**
     * 拿后缀
     *
     * @param fileName
     * @return
     */
    public static String getSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."));
    }

    /**
     * 源文件名称
     *
     * @param fileOriginName
     * @return
     */
    public static String getFileName(String fileOriginName) {
        return FileNameUtils.getSuffix(fileOriginName);
    }


    /**
     * UUID源文件名称
     *
     * @param fileOriginName
     * @return
     */
    public static String getUUIDFileName(String fileOriginName) {
        return UUID.randomUUID().toString().replace("-", "") + FileNameUtils.getSuffix(fileOriginName);
    }


}
