package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.CommonPage;
import com.live.common.domain.request.ImageCallbackRequest;
import com.live.common.domain.request.VersionRequest;
import com.live.common.service.CommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/common")
@Api(tags = "通用接口 API 文档")
public class CommonController {

    @Resource
    private CommonService commonService;

    @RequestMapping(value = "/checkVersion", method = {RequestMethod.POST})
    @ApiOperation(value = "各端版本检查 clientName：ios, android")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> checkVersion(@RequestBody VersionRequest versionRequest, HttpServletRequest request) throws Exception {
        return commonService.checkVersion(versionRequest, request);
    }

//    @RequestMapping(value = "/getMessageList", method = {RequestMethod.POST})
//    @ApiOperation(value = "获取公告列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> getMessageList(@RequestBody CommonPage commonPage, HttpServletRequest request) {
//        return commonService.getMessageList(commonPage, request);
//    }
//
    @RequestMapping(value = "/getShareConfig", method = {RequestMethod.POST})
    @ApiOperation(value = "获取分享配置")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getShareConfig(HttpServletRequest request) {
        return commonService.getShareConfig(request);
    }
//
//    @ApiIgnore
//    @RequestMapping(value = "/imageCallback", method = {RequestMethod.POST})
//    @ApiOperation(value = "腾讯直播截图回调")
//    public void imageCallback(@RequestBody ImageCallbackRequest callbackRequest, HttpServletRequest request) {
//        commonService.imageCallback(callbackRequest, request);
//    }

}
