package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CrawlIndexCompanyFootballDto {

    private String state;

    private List<CrawlIndexCompanyFootballInfoDto> mainOdds;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CrawlIndexCompanyFootballInfoDto {
        private Integer matchId;
        private String startTime;
        //主队名称
        private String homeTeamName;
        //客队名称
        private String awayTeamName;
        private Integer isReverse;

        private List<IndexFootballInfoOuZhiOddsDto> ouzhiOdds;
        private List<IndexFootballInfoYaZhiOddsDto> yazhiOdds;
        private List<IndexFootballInfoDaXiaoOddsDto> daxiaoOdds;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IndexFootballInfoOuZhiOddsDto {
        //公司ID
        private Integer companyId;
        //类型（0: 初盘, 1: 即时盘）
        private Integer type;
        //主胜赔率
        private Double win;
        //平局赔率
        private Double draw;
        //客胜赔率
        private Double loss;
        //变盘时间
        private String changeTime;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IndexFootballInfoYaZhiOddsDto {
        //公司ID
        private Integer companyId;
        //类型（0: 初盘, 1: 即时盘）
        private Integer type;
        //让球
        private Double handicap;
        //主队赔率
        private Double home;
        //客胜赔率
        private Double away;
        //变盘时间
        private String changeTime;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class IndexFootballInfoDaXiaoOddsDto {
        //公司ID
        private Integer companyId;
        //类型（0: 初盘, 1: 即时盘）
        private Integer type;
        //盘口
        private Double handicap;
        //大球赔率
        private Double over;
        //小球赔率
        private Double under;
        //变盘时间
        private String changeTime;
    }
}
