package com.live.job.service;

import com.live.common.domain.entity.ScheduledTask;
import com.live.common.mapper.ScheduledTaskMapper;
import com.live.job.constant.CrawlPlatformEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;

@Slf4j
@Component
public class ScheduledService {

    private ThreadPoolExecutor threadPoolExecutor;
    private CrawlStrategyFactory crawStrategyFactory;
    private ScheduledTaskMapper scheduledTaskMapper;
    @Resource
    private ThreadPoolTaskScheduler taskScheduler;


    /**
     * 10 分钟爬取一次 AlStat 足球盘口指数
     */
//    @Scheduled(fixedRate = 10 * 60 * 1000)
    @Scheduled(cron = "01 15/10 * * * ?")
    public void crawlIndexCompanyFootball(){
        String desc = "10 分钟爬取一次 AlStat 足球盘口指数";
        log.info(desc);
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlIndexCompanyFootball")
                .methodDesc(desc)
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlIndexCompanyFootball("http://data61.aistat.cn/zhishu/mainOdds?key=");
    }

    /**
     * 11 分钟爬取一次 AlStat 篮球盘口指数
     */
//    @Scheduled(fixedRate = 10 * 60 * 1000)
    @Scheduled(cron = "01 13/11 * * * ?")
    public void crawlIndexCompanyBasketball(){
        String desc = "11 分钟爬取一次 AlStat 篮球盘口指数";
        log.info(desc);
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlIndexCompanyBasketball")
                .methodDesc(desc)
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlIndexCompanyBasketball("http://data91.aistat.cn/basketball/zhishu/mainOdds?key=");
    }

    /**
     * 20 分钟爬取一次 AlStat 篮球赛程
     */
//    @Scheduled(fixedRate = 2 * 60 * 60 * 1000)
    @Scheduled(cron = "01 20/20 * * * ?")
    public void crawlAlStatBasketball(){
        log.info("20 分钟爬取一次 AlStat 篮球赛程");
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlAlStatBasketball")
                .methodDesc("20 分钟爬取一次 AlStat 篮球赛程")
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlScheduleMatch("http://data71.aistat.cn/basketball/matchs/queryFixtureByDate?key=");
    }

    /**
     * 篮球赛事阶段比分 -> 赛况
     */
//    @Scheduled(fixedRate = 10 * 60 * 1000)
    @Scheduled(cron = "01 12/10 * * * ?")
    public void crawlAlStatBasketballMatchStageScore(){
        log.info("10 分钟爬取一次 AlStat 篮球赛况");
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlAlStatBasketballMatchStageScore")
                .methodDesc("10 分钟爬取一次 AlStat 篮球赛况")
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlMatchStageScore("http://data71.aistat.cn/basketball/matchs/liveScores?key=");
    }

    /**
     * 20 分钟爬取一次 AlStat 足球赛程
     */
//    @Scheduled(fixedRate = 2 * 60 * 60 * 1000)
    @Scheduled(cron = "01 21/20 * * * ?")
    public void crawlAlStatFootball(){
        log.info("20 分钟爬取一次 AlStat 足球赛程");
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlAlStatFootball")
                .methodDesc("20 分钟爬取一次 AlStat 足球赛程")
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlScheduleMatch("http://data43.aistat.cn/competitions/queryFixtureByDate?key=");
    }

    @Scheduled(cron = "01 10 01 * * ?")
    public void crawlAlStatFootballEverOne(){
        String desc = "每天爬取一次 3 天后的 AlStat 足球赛程";
        log.info(desc);
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlAlStatFootballEverOne")
                .methodDesc(desc)
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlScheduleMatchByDay("http://data43.aistat.cn/competitions/queryFixtureByDate?key=", 3);
    }

    @Scheduled(cron = "01 10 02 * * ?")
    public void crawlAlStatBasketballEverOne(){
        String desc = "每天爬取一次 3 天后的 AlStat 篮球赛程";
        log.info(desc);
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlAlStatBasketballEverOne")
                .methodDesc(desc)
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.AlStat.getCode())
                .crawlScheduleMatchByDay("http://data71.aistat.cn/basketball/matchs/liveScores?key=", 3);
    }

    /**
     * 每天爬取一次资讯
     */
//    @Scheduled(fixedRate = 5 * 60 * 60 * 1000)
    @Scheduled(cron = "01 01 0/05 * * ?")
    public void crawlArticle() {
        log.info("五小时爬取资讯");
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("crawlArticle")
                .methodDesc("五小时爬取资讯")
                .build());

        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.ARTICLE24BWZ.getCode())
                .crawlScheduleArticle("https://www.24zbw.com/news/lanqiu/");

        taskScheduler.schedule(() -> crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.ARTICLE24BWZ.getCode())
                .crawlScheduleArticle("https://www.24zbw.com/news/zuqiu/"), Instant.now().plusSeconds(2 * 60));

        taskScheduler.schedule(() -> crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.ARTICLE24BWZ.getCode())
                .crawlScheduleArticle("https://www.24zbw.com/news/tag/shenshuiqu/"), Instant.now().plusSeconds(4 * 60));
    }

    /**
     * 每 5 分钟更新 sportlive360 赛程直播源
     */
    @Scheduled(cron = "50 01/5 * * * ?")
    public void updateSportLive360List() {
        scheduledTaskMapper.insert(ScheduledTask.builder()
                .createTime(new Date())
                .method("updateSportLive360List")
                .methodDesc("每 5 分钟更新 sportlive360 赛程直播源")
                .build());

        threadPoolExecutor.execute(() ->
                crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.SportLive360.getCode()).crawlScheduleMatch(null));
    }

//    /**
//     * 每天爬取一次 乐鱼 赛事 篮球
//     */
//    @Scheduled(cron = "01 01/12 * * * ?")
//    public void crawlBasketball() {
//        log.info("爬取篮球赛事");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("crawlBasketball")
//                .methodDesc("12 分钟爬取一次 乐鱼 赛事 篮球")
//                .build());
//
//        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.LeYu.getCode())
//                .crawlScheduleMatch("http://preview.611.com/api/Index/getLiveData?tabId=b5f013cd-777b-4b36-85b1-a0f9cbc0a5ee&tabName=%E7%AF%AE%E7%90%83&groupName=&millinsecond=&isFuture=true");
//    }
//
//    /**
//     * 每天爬取一次 乐鱼 赛事 足球
//     */
//    @Scheduled(cron = "10 01/11 * * * ?")
//    public void crawlFootball() {
//        log.info("爬取足球赛事");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("crawlFootball")
//                .methodDesc("11 分钟爬取一次 乐鱼 赛事 足球")
//                .build());
//
//        crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.LeYu.getCode())
//                .crawlScheduleMatch("http://preview.611.com/api/Index/getLiveData?tabId=0ecfe170-15de-4c6d-ae89-fb37920ea616&tabName=%E8%B6%B3%E7%90%83&groupName=&millinsecond=&isFuture=true");
//    }
//
//    @Scheduled(cron = "01 02/10 * * * ?")
//    public void updateMatchSchedule() {
//        log.info("更新乐鱼赛程");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("updateMatchSchedule")
//                .methodDesc("10分钟 乐鱼 赛程")
//                .build());
//
//        updateMatchStateService.updateStateMatch();
//    }
//
//    /**
//     * 每 30 分钟更新 乐鱼 赛程
//     */
//    @Scheduled(cron = "40 30/30 * * * ?")
//    public void updateMatchList() {
//        log.info("更新赛程");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("updateMatchList")
//                .methodDesc("每 30 分钟更新 乐鱼 赛程")
//                .build());
//
//        threadPoolExecutor.execute(() -> crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.LeYu.getCode()).updateMatchList());
//    }
//
//    /**
//     * 每 10 分钟爬取一次 UU球 主播信息
//     */
//    @Scheduled(cron = "50 10/10 * * * ?")
//    public void crawlUUQiuAnchor() {
//        log.info("爬取主播信息");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("crawlUUQiuAnchor")
//                .methodDesc("每 10 分钟爬取一次 UU球 主播信息")
//                .build());
//
//        threadPoolExecutor.execute(() ->
//                crawStrategyFactory.getCrawlAnchorService(CrawlPlatformEnum.UUQiu.getCode()).crawlAnchor()
//        );
//    }
//
//    /**
//     * 每 30 分钟更新 UU球 主播
//     */
//    @Scheduled(cron = "20 30/30 * * * ?")
//    public void updateUUQiuAnchor() {
//        log.info("更新主播");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("updateUUQiuAnchor")
//                .methodDesc("每 30 分钟更新 UU球 主播")
//                .build());
//
//        threadPoolExecutor.execute(() ->
//                crawStrategyFactory.getCrawlAnchorService(CrawlPlatformEnum.UUQiu.getCode()).updateAllAnchor()
//        );
//    }
//
//    /**
//     * 每 30 分钟更新 UU球 赛程
//     */
//    @Scheduled(cron = "33 30/30 * * * ?")
//    public void crawlUUQiuMatchList() {
//        log.info("更新 UU球 赛程");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("crawlUUQiuMatchList")
//                .methodDesc("每 30 分钟更新 UU球 赛程")
//                .build());
//
//        threadPoolExecutor.execute(() ->
//                crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.UUQiu.getCode()).crawlScheduleMatch("http://uuqiu.net/match/list")
//        );
//    }
//
//    /**
//     * 每 10 分钟爬取一次 红杉 主播信息
//     */
//    @Scheduled(cron = "10 10/10 * * * ?")
//    public void crawlSequoiaAnchor() {
//        log.info("爬取主播信息");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("crawlSequoiaAnchor")
//                .methodDesc("每 10 分钟爬取一次 红杉 主播信息")
//                .build());
//
//        threadPoolExecutor.execute(() ->
//                crawStrategyFactory.getCrawlAnchorService(CrawlPlatformEnum.Sequoia.getCode()).crawlAnchor()
//        );
//    }
//
//    /**
//     * 每 30 分钟更新 红杉 主播
//     */
//    @Scheduled(cron = "30 30/30 * * * ?")
//    public void updateSequoiaAnchor() {
//        log.info("更新主播");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("updateSequoiaAnchor")
//                .methodDesc("每 30 分钟更新 红杉 主播")
//                .build());
//
//        threadPoolExecutor.execute(() ->
//                crawStrategyFactory.getCrawlAnchorService(CrawlPlatformEnum.Sequoia.getCode()).updateAllAnchor()
//        );
//    }
//
//    /**
//     * 每 30 分钟更新 红杉 赛程
//     */
//    @Scheduled(cron = "01 30/30 * * * ?")
//    public void crawlSequoiaMatchList() {
//        log.info("更新 红杉 赛程");
//        scheduledTaskMapper.insert(ScheduledTask.builder()
//                .createTime(new Date())
//                .method("crawlSequoiaMatchList")
//                .methodDesc("每 30 分钟更新 红杉 赛程")
//                .build());
//
//        threadPoolExecutor.execute(() ->
//                crawStrategyFactory.getCrawMatchService(CrawlPlatformEnum.Sequoia.getCode()).crawlScheduleMatch("http://hszb.cc/match/list")
//        );
//    }

    @Lazy
    @Resource
    public void setCrawStrategyFactory(CrawlStrategyFactory crawStrategyFactory) {
        this.crawStrategyFactory = crawStrategyFactory;
    }

    @Autowired
    public void setScheduledTaskMapper(ScheduledTaskMapper scheduledTaskMapper) {
        this.scheduledTaskMapper = scheduledTaskMapper;
    }

    @Autowired
    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

}
