package com.live.job.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.live.common.domain.entity.RobotMsg;
import com.live.common.mapper.RobotMsgMapper;
import com.live.job.entity.dto.*;
import com.live.job.service.CrawlChatHistoryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Slf4j
@Service
public class CrawlChatHistoryServiceImpl implements CrawlChatHistoryService {

    @Resource
    private RestTemplate restTemplate;
    @Resource
    private RobotMsgMapper robotMsgMapper;

    private final HttpHeaders headers;

    public CrawlChatHistoryServiceImpl() {
        headers = new HttpHeaders();
        headers.add("User-Agent", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Mobile Safari/537.36");
        headers.add("Connection", "keep-alive");
        headers.setAccept(Collections.singletonList(APPLICATION_JSON));
    }

    @Override
//    @Scheduled(fixedRate = 20 * 60 * 1000)
    @Scheduled(cron = "01 10/20 * * * ?")
    public void crawlTg2ChatHistory() {
        log.info("爬取http://tg2.qqzb.vip/正在直播列表");
        String url = "http://tg2.qqzb.vip/home/index-pc1";
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            if (jsonObject.getInteger("code") == 200) {
                CrawlTg2LiveListDto userIdList = JSONObject.toJavaObject(jsonObject, CrawlTg2LiveListDto.class);
                for (CrawlTg2LiveListDto.HotLiveInfo userId : userIdList.getData().getHot_list()) {
                    crawlTg2ChatHistoryInfo(userId.getUser_id());
                }
                for (CrawlTg2LiveListDto.HotLiveInfo userId : userIdList.getData().getRecommend_list()) {
                    crawlTg2ChatHistoryInfo(userId.getUser_id());
                }
                log.info("爬取聊天历史记录结束");
            }
        }
    }

    @Override
//    @Scheduled(fixedRate = 20 * 60 * 1000)
    @Scheduled(cron = "10 10/20 * * * ?")
    public void crawlQiuShenChatHistory() {
        log.info("爬取 https://qiushenzhibo1.com/d 正在直播列表");
        String url = "https://api.zclhsq.com/schedules/broadcaster/replay/1/?getReplayData";
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            if (jsonObject.getInteger("status") == 1) {
                CrawlQiuShenLiveListDto qiuShenLiveListDto = JSONObject.toJavaObject(jsonObject, CrawlQiuShenLiveListDto.class);
                for (CrawlQiuShenLiveListDto.CrawlQiuShenLiveInfoCollection collection : qiuShenLiveListDto.getResult().getCollection()) {
                    try {
                        crawlQiuShenChatHistoryInfo(collection.get_id(), collection.getSchedule().getBroadcasters().get(0).getProfile().getId());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                log.info("爬取聊天历史记录结束");
            }
        }
    }

    private void crawlQiuShenChatHistoryInfo(String id, String profileId) {
        String url = String.format("https://api.zclhsq.com/chat/history/%s:%s/1?chatHistory", id, profileId);
        ResponseEntity<String> response = restTemplate.getForEntity(url, String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            if (jsonObject.getInteger("status") == 1) {
                CrawlQiuShenChatHistoryDto qiuShenChatHistoryDto = JSONObject.toJavaObject(jsonObject, CrawlQiuShenChatHistoryDto.class);
                for(CrawlQiuShenChatHistoryDto.ChatInfoCollection collection : qiuShenChatHistoryDto.getResult().getCollection()){
                    try {
                        robotMsgMapper.insert(RobotMsg.builder()
                                .fakeMsg(collection.getData().getMessage())
                                .nickName(collection.getData().getNickname())
                                .sourceUrl(url)
                                .build());
                    } catch (DuplicateKeyException e) {
                        //nothing
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void crawlTg2ChatHistoryInfo(String userId) {
        Map<String, String> requestMap = new HashMap<>();
        requestMap.put("live_id", userId);
        String url = "http://tg2.qqzb.vip/live/chat-history";

        ResponseEntity<String> response = restTemplate.postForEntity(url, new HttpEntity<>(requestMap, headers), String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            if (jsonObject.getInteger("code") == 200) {
                CrawlTg2ChatHistoryDto chatHistoryDto = JSONObject.toJavaObject(jsonObject, CrawlTg2ChatHistoryDto.class);
                for (CrawlTg2ChatHistoryDto.CrawlTg2ChatHistoryInfo chatMsg : chatHistoryDto.getData()) {
                    try {
                        robotMsgMapper.insert(RobotMsg.builder()
                                .fakeMsg(chatMsg.getContent())
                                .nickName(chatMsg.getNick_name())
                                .sourceUrl(url)
                                .build());
                    } catch (DuplicateKeyException e) {
                        //nothing
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

}
