package com.live.common.service.impl;

import com.live.common.service.RedisUtilsService;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

@Service
public class RedisUtilsServiceImpl implements RedisUtilsService {

    @Resource
    private RedisTemplate<Serializable, Object> redisTemplate;

    @Override
    public boolean existsKey(String key) {
        return redisTemplate.hasKey(key);
    }

    @Override
    public String getCacheStringInfo(String key) {
        Object object = redisTemplate.opsForValue().get(key);
        return object != null ? object.toString() : null;
    }

    @Override
    public void cacheStringInfo(String key, String value, long timeOut) {
        redisTemplate.opsForValue().set(key, value, timeOut, TimeUnit.SECONDS);
    }

    @Override
    public void cacheStringInfoByDay(String key, String value, long day) {
        redisTemplate.opsForValue().set(key, value, day, TimeUnit.DAYS);
    }

    @Override
    public void removeByKey(String key) {
        redisTemplate.delete(key);
    }

}
