//package com.live.common.utils;
//
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.data.redis.core.RedisTemplate;
//import org.springframework.data.redis.core.script.DefaultRedisScript;
//import org.springframework.data.redis.core.script.RedisScript;
//import org.springframework.data.redis.support.atomic.RedisAtomicLong;
//import org.springframework.util.CollectionUtils;
//
//import java.text.SimpleDateFormat;
//import java.util.*;
//import java.util.concurrent.TimeUnit;
//
///**
// * redis 工具类
// */
//@Slf4j
//public class RedisUtil {
//	private static final Long SUCCESS = 1L;
//	private RedisTemplate<String, Object> redisTemplate;
//
//	public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
//		this.redisTemplate = redisTemplate;
//	}
//	//=============================common============================
//
//	/**
//	 * 根据时间获取自增长ID
//	 * @param key
//	 * @return
//	 */
//	public String generate(String key) {
//		RedisAtomicLong counter = new RedisAtomicLong(key,redisTemplate.getConnectionFactory());
//		Date date = new Date();
//		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
//		String format = formatter.format(date);
//
//		return format+String.valueOf(counter.incrementAndGet());
//	}
//
//
//
//	/**
//	 * 指定缓存失效时间
//	 *
//	 * @param key  键
//	 * @param time 时间(秒)
//	 * @return
//	 */
//	public boolean expire(String key, long time) {
//		try {
//			if (time > 0) {
//				redisTemplate.expire(key, time, TimeUnit.SECONDS);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis set key expire exception key={} , e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 根据key 获取过期时间
//	 *
//	 * @param key 键 不能为null
//	 * @return 时间(秒) 返回0代表为永久有效
//	 */
//	public long getExpire(String key) {
//		return redisTemplate.getExpire(key, TimeUnit.SECONDS);
//	}
//
//	/**
//	 * 判断key是否存在
//	 *
//	 * @param key 键
//	 * @return true 存在 false不存在
//	 */
//	public boolean hasKey(String key) {
//		try {
//			return redisTemplate.hasKey(key);
//		} catch (Exception e) {
//			log.error("redis haskey exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 删除缓存
//	 *
//	 * @param key 可以传一个值 或多个
//	 */
//	public void del(String... key) {
//		if (key != null && key.length > 0) {
//			if (key.length == 1) {
//				redisTemplate.delete(key[0]);
//			} else {
//				redisTemplate.delete(CollectionUtils.arrayToList(key));
//			}
//		}
//	}
//
//	//============================String=============================
//
//	/**
//	 * 普通缓存获取
//	 *
//	 * @param key 键
//	 * @return 值
//	 */
//	public Object get(String key) {
//		return key == null ? null : redisTemplate.opsForValue().get(key);
//	}
//
//
//	/**
//	 * 普通缓存放入
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @return true成功 false失败
//	 */
//	public boolean set(String key, Object value) {
//		try {
//			redisTemplate.opsForValue().set(key, value);
//			return true;
//		} catch (Exception e) {
//			log.error("redis set key exception key={},e={}", key, e);
//			return false;
//		}
//
//	}
//
//	/**
//	 * 普通缓存放入并设置时间
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @param time  时间(秒) time要大于0 如果time小于等于0 将设置无限期
//	 * @return true成功 false 失败
//	 */
//	public boolean set(String key, Object value, long time) {
//		try {
//			if (time > 0) {
//				redisTemplate.opsForValue().set(key, value, time, TimeUnit.SECONDS);
//			} else {
//				set(key, value);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis set time key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	public boolean set(String key, Object value, long time,TimeUnit unit) {
//		try {
//			if (time > 0) {
//				redisTemplate.opsForValue().set(key, value,time, unit);
//			} else {
//				set(key, value);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis set time key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 递增
//	 *
//	 * @param key   键
//	 * @param delta 要增加几(大于0)
//	 * @return
//	 */
//	public long incr(String key, long delta) {
//		if (delta < 0) {
//			throw new RuntimeException("递增因子必须大于0");
//		}
//		return redisTemplate.opsForValue().increment(key, delta);
//	}
//
//	/**
//	 * 递减
//	 *
//	 * @param key   键
//	 * @param delta 要减少几
//	 * @return
//	 */
//	public long decr(String key, long delta) {
//		if (delta < 0) {
//			throw new RuntimeException("递减因子必须大于0");
//		}
//		return redisTemplate.opsForValue().increment(key, -delta);
//	}
//
//	//================================Map=================================
//
//	/**
//	 * HashGet
//	 *
//	 * @param key  键 不能为null
//	 * @param item 项 不能为null
//	 * @return 值
//	 */
//	public Object hget(String key, String item) {
//		return redisTemplate.opsForHash().get(key, item);
//	}
//
//	/**
//	 * 获取hashKey对应的所有键值
//	 *
//	 * @param key 键
//	 * @return 对应的多个键值
//	 */
//	public Map<Object, Object> hmget(String key) {
//		return redisTemplate.opsForHash().entries(key);
//	}
//
//	/**
//	 * HashSet
//	 *
//	 * @param key 键
//	 * @param map 对应多个键值
//	 * @return true 成功 false 失败
//	 */
//	public boolean hmset(String key, Map<String, Object> map) {
//		try {
//			redisTemplate.opsForHash().putAll(key, map);
//			return true;
//		} catch (Exception e) {
//			log.error("redis hmset  key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * HashSet 并设置时间
//	 *
//	 * @param key  键
//	 * @param map  对应多个键值
//	 * @param time 时间(秒)
//	 * @return true成功 false失败
//	 */
//	public boolean hmset(String key, Map<String, Object> map, long time) {
//		try {
//			redisTemplate.opsForHash().putAll(key, map);
//			if (time > 0) {
//				expire(key, time);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis hmset time key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 向一张hash表中放入数据,如果不存在将创建
//	 *
//	 * @param key   键
//	 * @param item  项
//	 * @param value 值
//	 * @return true 成功 false失败
//	 */
//	public boolean hset(String key, String item, Object value) {
//		try {
//			redisTemplate.opsForHash().put(key, item, value);
//			return true;
//		} catch (Exception e) {
//			log.error("redis hset  key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 向一张hash表中放入数据,如果不存在将创建
//	 *
//	 * @param key   键
//	 * @param item  项
//	 * @param value 值
//	 * @param time  时间(秒)  注意:如果已存在的hash表有时间,这里将会替换原有的时间
//	 * @return true 成功 false失败
//	 */
//	public boolean hset(String key, String item, Object value, long time) {
//		try {
//			redisTemplate.opsForHash().put(key, item, value);
//			if (time > 0) {
//				expire(key, time);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis hset item time key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 删除hash表中的值
//	 *
//	 * @param key  键 不能为null
//	 * @param item 项 可以使多个 不能为null
//	 */
//	public void hdel(String key, Object... item) {
//		redisTemplate.opsForHash().delete(key, item);
//	}
//
//	/**
//	 * 判断hash表中是否有该项的值
//	 *
//	 * @param key  键 不能为null
//	 * @param item 项 不能为null
//	 * @return true 存在 false不存在
//	 */
//	public boolean hHasKey(String key, String item) {
//		return redisTemplate.opsForHash().hasKey(key, item);
//	}
//
//	/**
//	 * hash递增 如果不存在,就会创建一个 并把新增后的值返回
//	 *
//	 * @param key  键
//	 * @param item 项
//	 * @param by   要增加几(大于0)
//	 * @return
//	 */
//	public double hincr(String key, String item, double by) {
//		return redisTemplate.opsForHash().increment(key, item, by);
//	}
//
//	/**
//	 * hash递减
//	 *
//	 * @param key  键
//	 * @param item 项
//	 * @param by   要减少几
//	 * @return
//	 */
//	public double hdecr(String key, String item, double by) {
//		return redisTemplate.opsForHash().increment(key, item, -by);
//	}
//
//	//============================set=============================
//
//	/**
//	 * 根据key获取Set中的所有值
//	 *
//	 * @param key 键
//	 * @return
//	 */
//	public Set<Object> sGet(String key) {
//		try {
//			return redisTemplate.opsForSet().members(key);
//		} catch (Exception e) {
//			log.error("redis sGet   key  exception key={},e={}", key, e);
//			return null;
//		}
//	}
//
//	/**
//	 * 根据value从一个set中查询,是否存在
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @return true 存在 false不存在
//	 */
//	public boolean sHasKey(String key, Object value) {
//		try {
//			return redisTemplate.opsForSet().isMember(key, value);
//		} catch (Exception e) {
//			log.error("redis sHasKey   key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 将数据放入set缓存
//	 *
//	 * @param key    键
//	 * @param values 值 可以是多个
//	 * @return 成功个数
//	 */
//	public long sSet(String key, Object... values) {
//		try {
//			return redisTemplate.opsForSet().add(key, values);
//		} catch (Exception e) {
//			log.error("redis sSet   key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * 将set数据放入缓存
//	 *
//	 * @param key    键
//	 * @param time   时间(秒)
//	 * @param values 值 可以是多个
//	 * @return 成功个数
//	 */
//	public long sSetAndTime(String key, long time, Object... values) {
//		try {
//			Long count = redisTemplate.opsForSet().add(key, values);
//			if (time > 0) {
//				expire(key, time);
//			}
//			return count;
//		} catch (Exception e) {
//			log.error("redis sSetAndTime   key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * 获取set缓存的长度
//	 *
//	 * @param key 键
//	 * @return
//	 */
//	public long sGetSetSize(String key) {
//		try {
//			return redisTemplate.opsForSet().size(key);
//		} catch (Exception e) {
//			log.error("redis sGetSetSize   key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * set移除值为value的
//	 *
//	 * @param key    键
//	 * @param values 值 可以是多个
//	 * @return 移除的个数
//	 */
//	public long setRemove(String key, Object... values) {
//		try {
//			Long count = redisTemplate.opsForSet().remove(key, values);
//			return count;
//		} catch (Exception e) {
//			log.error("redis setRemove   key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//	//===============================list=================================
//
//	/**
//	 * 获取list缓存的内容
//	 *
//	 * @param key   键
//	 * @param start 开始
//	 * @param end   结束  0 到 -1代表所有值
//	 * @return
//	 */
//	public List<Object> lGet(String key, long start, long end) {
//		try {
//			return redisTemplate.opsForList().range(key, start, end);
//		} catch (Exception e) {
//			log.error("redis lGet   key  exception key={},e={}", key, e);
//			return null;
//		}
//	}
//
//	/**
//	 * 获取list缓存的长度
//	 *
//	 * @param key 键
//	 * @return
//	 */
//	public long lGetListSize(String key) {
//		try {
//			return redisTemplate.opsForList().size(key);
//		} catch (Exception e) {
//			log.error("redis lGetListSize   key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * 通过索引 获取list中的值
//	 *
//	 * @param key   键
//	 * @param index 索引  index>=0时， 0 表头，1 第二个元素，依次类推；index<0时，-1，表尾，-2倒数第二个元素，依次类推
//	 * @return
//	 */
//	public Object lGetIndex(String key, long index) {
//		try {
//			return redisTemplate.opsForList().index(key, index);
//		} catch (Exception e) {
//			log.error("redis lGetIndex   key  exception key={},e={}", key, e);
//			return null;
//		}
//	}
//
//	/**
//	 * 将list放入缓存
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @return
//	 */
//	public boolean lSet(String key, Object value) {
//		try {
//			redisTemplate.opsForList().rightPush(key, value);
//			return true;
//		} catch (Exception e) {
//			log.error("redis lSet   key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 将list放入缓存
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @param time  时间(秒)
//	 * @return
//	 */
//	public boolean lSet(String key, Object value, long time) {
//		try {
//			redisTemplate.opsForList().rightPush(key, value);
//			if (time > 0) {
//				expire(key, time);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis lSet time  key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 将list放入缓存
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @return
//	 */
//	public boolean lSet(String key, List<Object> value) {
//		try {
//			redisTemplate.opsForList().rightPushAll(key, value);
//			return true;
//		} catch (Exception e) {
//			log.error("redis lSet list  key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 将list放入缓存
//	 *
//	 * @param key   键
//	 * @param value 值
//	 * @param time  时间(秒)
//	 * @return
//	 */
//	public boolean lSet(String key, List<Object> value, long time) {
//		try {
//			redisTemplate.opsForList().rightPushAll(key, value);
//			if (time > 0) {
//				expire(key, time);
//			}
//			return true;
//		} catch (Exception e) {
//			log.error("redis lSet list time key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 根据索引修改list中的某条数据
//	 *
//	 * @param key   键
//	 * @param index 索引
//	 * @param value 值
//	 * @return
//	 */
//	public boolean lUpdateIndex(String key, long index, Object value) {
//		try {
//			redisTemplate.opsForList().set(key, index, value);
//			return true;
//		} catch (Exception e) {
//			log.error("redis lSet list key  exception key={},index={},e={}", key, index, e);
//			return false;
//		}
//	}
//
//	/**
//	 * list移除N个值为value
//	 *
//	 * @param key   键
//	 * @param count 移除多少个
//	 * @param value 值
//	 * @return 移除的个数
//	 */
//	public long lRemove(String key, long count, Object value) {
//		try {
//
//			Long remove = redisTemplate.opsForList().remove(key, count, value);
//			return remove;
//		} catch (Exception e) {
//			log.error("redis lRemove key  exception key={},count={},e={}", key, count, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * 获取key统计数据
//	 *
//	 * @param key 键
//	 * @return 统计数
//	 */
//	public long getHyperLogLogBykey(String key) {
//		try {
//			long count = redisTemplate.opsForHyperLogLog().size(key);
//			return count;
//		} catch (Exception ex) {
//			log.error("redis getHyperLogLogBykey key  exception key={},e={}", key, ex);
//			return 0;
//		}
//	}
//
//	/**
//	 * 添加统计对象
//	 *
//	 * @param key 键
//	 * @param obj 统计对象 支持多个
//	 * @return
//	 */
//	public long setHyperLogLog(String key, Object... obj) {
//		try {
//			long count = redisTemplate.opsForHyperLogLog().add(key, obj);
//			return count;
//		} catch (Exception e) {
//			log.error("redis setHyperLogLog key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * 返回统计结果  会有一些偏差  常用uv、pv统计  优势占用内存小
//	 *
//	 * @param key  键
//	 * @param strs 新增统计对象  支持多个
//	 * @return
//	 */
//	public long unionHyperLogLog(String key, String... strs) {
//		try {
//			long count = redisTemplate.opsForHyperLogLog().union(key, strs);
//			return count;
//		} catch (Exception e) {
//			log.error("redis unionHyperLogLog key  exception key={},e={}", key, e);
//			return 0;
//		}
//	}
//
//	/**
//	 * 删除键
//	 *
//	 * @param key 键
//	 * @return
//	 */
//	public boolean delHyperLogLogByKey(String key) {
//		try {
//			redisTemplate.opsForHyperLogLog().delete(key);
//			return true;
//		} catch (Exception e) {
//			log.error("redis delHyperLogLogByKey key  exception key={},e={}", key, e);
//			return false;
//		}
//	}
//
//	/**
//	 * 获取锁
//	 *
//	 * @param lockKey    redis键值对 的 key
//	 * @param value      redis键值对 的 value  随机串作为值
//	 * @param expireTime redis键值对 的 过期时间   expire 以毫秒为单位
//	 * @return
//	 */
//	public boolean getLock(String lockKey, String value, int expireTime) {
//
//		try {
//			String script = "if redis.call('setNx',KEYS[1],ARGV[1]) then if redis.call('get',KEYS[1])==ARGV[1] then return redis.call('expire',KEYS[1],ARGV[2]) else return 0 end end";
//			RedisScript<String> redisScript = new DefaultRedisScript<>(script, String.class);
//			Object result = redisTemplate.execute(redisScript, Collections.singletonList(lockKey), value, expireTime);
//			if (SUCCESS.equals(result)) {
//				return true;
//			}
//		} catch (Exception e) {
//			log.info("getLock exception key={}", lockKey);
//		}
//		return false;
//	}
//
//	/**
//	 * 释放锁
//	 *
//	 * @param lockKey 释放本请求对应的锁的key
//	 * @param value   释放本请求对应的锁的value  是不重复随即串 用于比较，以免释放别的线程的锁
//	 * @return
//	 */
//	public boolean releaseLock(String lockKey, String value) {
//		String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
//		RedisScript<String> redisScript = new DefaultRedisScript<>(script, String.class);
//		Object result = redisTemplate.execute(redisScript, Collections.singletonList(lockKey), value);
//		if (SUCCESS.equals(result)) {
//			return true;
//		}
//		return false;
//	}
//
//
//}
