package com.live.job.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.domain.entity.Match;
import com.live.common.domain.entity.Room;
import com.live.common.domain.entity.RoomHostRecord;
import com.live.common.domain.entity.Team;
import com.live.common.mapper.*;
import com.live.common.utils.DateUtil;
import com.live.job.constant.CrawlPlatformEnum;
import com.live.job.entity.dto.*;
import com.live.job.service.CrawlMatchService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Slf4j
@Service
public class CrawlUUQiuServiceImpl implements CrawlMatchService {

    @Resource
    private TeamMapper teamMapper;
    @Resource
    private RoomMapper roomMapper;
    @Resource
    private MatchMapper matchMapper;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private RoomHostRecordMapper roomHostRecordMapper;

    private final HttpHeaders headers;

    public CrawlUUQiuServiceImpl() {
        headers = new HttpHeaders();
        headers.add("User-Agent", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Mobile Safari/537.36");
        headers.add("Connection", "keep-alive");
        headers.setAccept(Collections.singletonList(APPLICATION_JSON));
    }

    @Override
    public void crawlScheduleMatch(String url) {
        log.info("爬取 UU球 赛程");
        ResponseEntity<String> response = restTemplate.postForEntity(url, new HttpEntity<>(null, headers), String.class);
        if (response.getStatusCode() == HttpStatus.OK) {
            JSONObject jsonObject = JSONObject.parseObject(response.getBody());
            UUQiuMatchListDto qiuMatchListDto = JSONObject.toJavaObject(JSONObject.parseObject(jsonObject.get("data").toString())
                    , UUQiuMatchListDto.class);

            if (qiuMatchListDto != null) {
                for (UUQiuMatchListDto.UUQiuMatchInfo uuQiuMatchInfo : qiuMatchListDto.getList()) {
                    if (uuQiuMatchInfo.getAnchor_list() != null) {
                        //有主播直播的赛程
                        for (UUQiuMatchListDto.UUQiuMatchAnchorInfo anchorInfo : uuQiuMatchInfo.getAnchor_list()) {
                            List<Match> matchs = matchMapper.selectList(Wrappers.<Match>lambdaQuery()
                                    .eq(Match::getDeleted, 0)
                                    .eq(Match::getSourceType, 0)
                                    .eq(Match::getMatchTime, DateUtil.format(DateUtil.getStartTime(), DateUtil.YMD_) + " " + uuQiuMatchInfo.getShow_match_time() + ":00")
                            );

                            for (Match match : matchs) {
                                Team away = teamMapper.selectById(match.getAwayId());
                                Team home = teamMapper.selectById(match.getHomeId());

                                boolean homeBool = away.getTeamName().contains(uuQiuMatchInfo.getAway_name())
                                        || away.getTeamName().contains(uuQiuMatchInfo.getHome_name())
                                        || home.getTeamName().contains(uuQiuMatchInfo.getAway_name())
                                        || home.getTeamName().contains(uuQiuMatchInfo.getHome_name());

                                boolean awayBool = uuQiuMatchInfo.getAway_name().contains(away.getTeamName())
                                        || uuQiuMatchInfo.getHome_name().contains(away.getTeamName())
                                        || uuQiuMatchInfo.getAway_name().contains(home.getTeamName())
                                        || uuQiuMatchInfo.getHome_name().contains(home.getTeamName());

                                if (homeBool || awayBool) {
                                    Room room = roomMapper.selectOne(Wrappers.<Room>lambdaQuery()
                                            .eq(Room::getDeleted, 0)
                                            .eq(Room::getUserId, anchorInfo.getUser_id())
                                    );
                                    if (room == null) {
                                        continue;
                                    }

                                    if (StringUtils.isBlank(room.getMatchId()) || !room.getMatchId().equals(match.getId())) {
                                        room.setMatchId(match.getId());
                                        roomMapper.updateById(room);
                                        log.info("{} -> 关联赛事 -> {}", room.getHuanXinRoomId(), room.getMatchId());

                                        try {
                                            roomHostRecordMapper.insert(RoomHostRecord.builder()
                                                    .receivedGold(0)
                                                    .roomId(room.getHuanXinRoomId())
                                                    .matchTime(match.getMatchTime())
                                                    .matchId(match.getId())
                                                    .hostUserId(room.getUserId())
                                                    .createTime(match.getMatchTime())
                                                    .endTime(DateUtil.getTmEndTime())
                                                    .build());
                                        } catch (DuplicateKeyException e) {
                                            //
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void crawlScheduleMatchByDay(String url, int day) {

    }

    @Override
    public void crawlIndexCompanyFootball(String url) {

    }

    @Override
    public void crawlIndexCompanyBasketball(String url) {

    }

    @Override
    public void crawlMatchStageScore(String url) {

    }

    @Override
    public void crawlScheduleArticle(String url, Integer sportsId) {

    }

    @Override
    public void updateMatchList() {

    }

    @Override
    public void updateFootballState(String matchId, long time) {

    }

    @Override
    public void updateBasketballState(String matchId, long time) {

    }

    @Override
    public String getPlatform() {
        return CrawlPlatformEnum.UUQiu.getCode();
    }

}
